package net.trique.wardentools.util.warden_curse;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;

public class WardenCurseClientHelper {
    private static final HashMap<Integer, Ticker> ENTITIES_TO_RENDER_GLOWING = new HashMap<>();
    private static final HashMap<class_2338, Ticker> BLOCKS_TO_OUTLINE = new HashMap<>();



    public static void tickClientGlowingEntities() {
        Iterator<Integer> iterator = ENTITIES_TO_RENDER_GLOWING.keySet().iterator();
        try {
            while(iterator.hasNext()) {
                int entityId = iterator.next();
                Ticker ticker = ENTITIES_TO_RENDER_GLOWING.get(entityId);
                if (!ticker.tick()) {
                    iterator.remove();
                }
            }
        } catch (ConcurrentModificationException ignored) {
        }
    }

    public static void tickOutlinedBlocks() {
        Iterator<class_2338> iterator = BLOCKS_TO_OUTLINE.keySet().iterator();
        try {
            while(iterator.hasNext()) {
                class_2338 entityId = iterator.next();
                Ticker ticker = BLOCKS_TO_OUTLINE.get(entityId);
                if (!ticker.tick()) {
                    iterator.remove();
                }
            }
        } catch (ConcurrentModificationException ignored) {
        }
    }

    public static Set<Integer> getEntitiesToRenderGlowing() {
        return ENTITIES_TO_RENDER_GLOWING.keySet();
    }

    public static void addEntity(int id, int ticks) {
        if (id != -1) ENTITIES_TO_RENDER_GLOWING.put(id, new Ticker(ticks));
    }

    public static void addBlockPos(class_2338 pos, int ticks) {
        BLOCKS_TO_OUTLINE.put(pos, new Ticker(ticks));
    }

    public static void renderOutlinedBlocks(class_4587 stack) {
        if (stack != null && !BLOCKS_TO_OUTLINE.isEmpty()) {
            class_4184 cam = class_310.method_1551().field_1773.method_19418();
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            Matrix4fStack posestack = RenderSystem.getModelViewStack();
            posestack.pushMatrix();
            posestack.mul(stack.method_23760().method_23761());
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShader(class_757::method_34535);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
            RenderSystem.lineWidth(5f);
            for (class_2338 pos : BLOCKS_TO_OUTLINE.keySet()) {
                Vector3f cameraPos = cam.method_19326().method_46409();
                float posx = pos.method_10263() - cameraPos.x();
                float posy = pos.method_10264() - cameraPos.y();
                float posz = pos.method_10260() - cameraPos.z();
                renderBlock(bufferBuilder, posx, posy, posz);
            }
            class_9801 data = bufferBuilder.method_60794();
            if (data != null) {
                class_286.method_43433(data);
            }
            posestack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private static void renderBlock(class_287 builder, float x, float y, float z) {
        int [][] offsets = {
                {0, 0, 0}, {0, 1, 0}, {0, 0, 0}, {1, 0, 0},
                {0, 0, 0}, {0, 0, 1}, {0, 1, 0}, {0, 1, 1},
                {0, 1, 0}, {1, 1, 0}, {1, 1, 1}, {1, 1, 0},
                {1, 1, 1}, {0, 1, 1}, {1, 1, 1}, {1, 0, 1},
                {1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {1, 0, 0},
                {0, 0, 1}, {0, 1, 1}, {1, 0, 0}, {1, 1, 0}
        };

        int [][] normals = {
                {0, 1, 0}, {0, -1, 0}, {1, 0, 0}, {-1, 0, 0},
                {0, 0, 1}, {0, 0, -1}, {0, 0, 1}, {0, 0, -1},
                {1, 0, 0}, {-1, 0, 0}, {0, 0, -1}, {0, 0, 1},
                {-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0},
                {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1},
                {0, 1, 0}, {0, -1, 0}, {0, 1, 0}, {0, -1, 0}
        };

        for (int i = 0; i < offsets.length; i++) {
            builder.method_22912(x + offsets[i][0], y + offsets[i][1], z + offsets[i][2])
                    .method_1336(41, 223, 235, 255)
                    .method_22914(normals[i][0], normals[i][1], normals[i][2]);
        }
    }
}
