package net.trique.wardentools.util.warden_curse;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_5698;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5716;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8514;
import net.minecraft.world.entity.*;
import net.trique.wardentools.config.WTConfigServer;
import net.trique.wardentools.item.armor.WardenMaskItem;
import net.trique.wardentools.networking.packet.AddBlockOutlinePacket;
import net.trique.wardentools.networking.packet.AddEntityGlowPacket;
import net.trique.wardentools.platform.Services;
import net.trique.wardentools.registry.EffectRegistry;
import net.trique.wardentools.util.WTGameEventTags;
import software.bernie.geckolib.animatable.GeoItem;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class WardenCurseUser implements class_8514 {
    protected class_1309 holder;
    protected int extraBonus = 0;
    private class_8514.class_8515 vibrationData = new class_8514.class_8515();
    private final class_8514.class_5719 vibrationUser;
    private final net.trique.wardentools.util.warden_curse.Ticker COOLDOWN_TICKER =
            new net.trique.wardentools.util.warden_curse.Ticker();

    public WardenCurseUser(class_1309 livingEntity) {
        holder = livingEntity;
        vibrationUser = new VibrationUser();
    }

    public WardenCurseUser(class_1309 livingEntity, int extraBonus) {
        this(livingEntity);
        this.extraBonus = extraBonus;
    }

    @Override
    public class_8515 method_51298() {
        return vibrationData;
    }

    public void setVibrationData(class_8515 vibrationData) {
        this.vibrationData = vibrationData;
    }

    @Override
    public class_5719 method_51299() {
        return vibrationUser;
    }

    public int getExtraBonus() {
        return extraBonus;
    }

    public void setExtraBonus(int extraBonus) {
        this.extraBonus = extraBonus;
    }

    public boolean hasCooldown() {
        return COOLDOWN_TICKER.hasRemainingDuration();
    }

    public void tickCooldown() {
        if (hasCooldown()) {
            COOLDOWN_TICKER.tick();
        }
    }

    class VibrationUser implements class_8514.class_5719 {
        private final class_5716 positionSource;

        public VibrationUser() {
            positionSource = new class_5709(holder, holder.method_5751());
        }

        @Override
        public int method_49797() {
            if (holder.method_6059(EffectRegistry.WARDEN_CURSE)) {
                int amplifier = holder.method_6112(EffectRegistry.WARDEN_CURSE).method_5578();
                return 8 * (amplifier + 1) + extraBonus;
            }
            return 0;
        }

        @Override
        public class_6862<class_5712> method_42210() {
            return WTGameEventTags.WARDEN_CURSE_USER_CAN_LISTEN;
        }

        @Override
        public class_5716 method_51300() {
            return positionSource;
        }

        @Override
        public boolean method_43695() {
            return true;
        }

        @Override
        public boolean method_42324(class_6880<class_5712> gameEvent, class_5712.class_7397 context) {
            if (!gameEvent.method_40220(this.method_42210())) {
                return false;
            } else {
                class_1297 entity = context.comp_713();
                if (entity != null) {
                    if (entity.method_7325() || entity.method_5779(holder)) {
                        return false;
                    }
                    if (entity.method_21749() && gameEvent.method_40220(class_5698.field_28091)) {
                        if (this.method_43695() && entity instanceof class_3222 serverplayer) {
                            class_174.field_38838.method_9141(serverplayer);
                        }
                        return false;
                    }
                    if (entity.method_33189()) {
                        return false;
                    }
                }
                return context.comp_714() == null || !context.comp_714().method_26164(class_3481.field_38835);
            }
        }

        @Override
        public boolean method_32970(class_3218 serverLevel, class_2338 blockPos, class_6880<class_5712> gameEventHolder, class_5712.class_7397 context) {
            if (!holder.method_29504() && holder.method_6059(EffectRegistry.WARDEN_CURSE)
                    && serverLevel.method_8621().method_11952(blockPos) && !hasCooldown()) {
                class_1297 source = context.comp_713();
                if (source instanceof class_1309 livingEntity) {
                    return this.canTargetEntity(livingEntity);
                }
                return true;
            } else {
                return false;
            }
        }

        @Override
        public void method_32969(class_3218 serverLevel, class_2338 blockPos, class_6880<class_5712> gameEventHolder, @Nullable class_1297 entity, @Nullable class_1297 possibleShooter, float distance) {
            if (!holder.method_29504() && holder.method_6059(EffectRegistry.WARDEN_CURSE)) {
                int amplifier = holder.method_6112(EffectRegistry.WARDEN_CURSE).method_5578();
                COOLDOWN_TICKER.setDuration(Math.max(10, 40 - amplifier * 10));
                if ((entity != null && !holder.method_5779(entity)) || (possibleShooter != null && !holder.method_5779(possibleShooter))) {
                    class_1799 head = holder.method_6118(class_1304.field_6169);
                    if (head.method_7909() instanceof WardenMaskItem mask) {
                        mask.triggerArmorAnim(holder, GeoItem.getOrAssignId(head, serverLevel),
                                "warden_mask", "tendrils_click");
                    }
                    serverLevel.method_43128(null, holder.method_23317(), holder.method_23318(), holder.method_23321(),
                            class_3417.field_38078, holder.method_5634(), 1.0F, holder.method_6017());
                }
                if (holder instanceof class_3222 player) {
                    int entity_glow_seconds = (int) (WTConfigServer.CONFIG.seconds_to_glow_entity.get() * 20);
                    int block_outline_seconds = (int) (WTConfigServer.CONFIG.seconds_to_outline_block.get() * 20);
                    if (entity != null && !entity.equals(holder)) {
                        Services.PACKET_HELPER.sendPacket(player, new AddEntityGlowPacket(entity.method_5628(),
                                entity_glow_seconds));
                        Services.PACKET_HELPER.sendPacket(player, new AddBlockOutlinePacket(blockPos,
                                block_outline_seconds));
                    }
                    if (possibleShooter != null && !possibleShooter.equals(holder)) {
                        Services.PACKET_HELPER.sendPacket(player, new AddEntityGlowPacket(possibleShooter.method_5628(),
                                entity_glow_seconds));
                        Services.PACKET_HELPER.sendPacket(player, new AddBlockOutlinePacket(
                                possibleShooter.method_23312().method_10084(), block_outline_seconds
                        ));
                    }
                }
            }
        }

        @Contract("null->false")
        protected boolean canTargetEntity(@Nullable class_1297 entity) {
            if (entity instanceof class_1309 livingentity) {
                return holder.method_37908() == entity.method_37908() && class_1301.field_6156.test(entity) &&
                        !holder.method_5722(entity) && livingentity.method_5864() != class_1299.field_6131
                        && !livingentity.method_5655() && !livingentity.method_29504() &&
                        holder.method_37908().method_8621().method_11966(livingentity.method_5829());
            }
            return false;
        }
    }
}
