/*
 * Decompiled with CFR 0.152.
 */
package toolleprechaun.speedforghasts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import toolleprechaun.speedforghasts.SpeedForGhasts;

public class Config {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "speed-for-ghasts.json");
    public static Config INSTANCE = new Config();
    public double speed1Multiplier = 1.4;
    public double speed2Multiplier = 1.8;

    public static void load() {
        if (FILE.exists()) {
            try (FileReader reader = new FileReader(FILE);){
                INSTANCE = (Config)GSON.fromJson((Reader)reader, Config.class);
                SpeedForGhasts.LOGGER.info("[Speed for Ghasts] Config loaded from {}", (Object)FILE.getAbsolutePath());
            }
            catch (IOException e) {
                SpeedForGhasts.LOGGER.error("[Speed for Ghasts] Failed to load config, using defaults", (Throwable)e);
            }
        } else {
            Config.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
            SpeedForGhasts.LOGGER.info("[Speed for Ghasts] Config saved to {}", (Object)FILE.getAbsolutePath());
        }
        catch (IOException e) {
            SpeedForGhasts.LOGGER.error("[Speed for Ghasts] Failed to save config", (Throwable)e);
        }
    }
}

