package net.cookedseafood.genericregistry.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

/**
 * A registry holds a map for a single type of object.
 * 
 * <p>This should <i>NOT</i> be instanced manualy.</p>
 * 
 * @see Registries#register(class_2960, Object)
 * @see Registries#get(Class, class_2960)
 */
public class Registry<T> {
    private final Map<class_2960, T> registry;

    public Registry(Map<class_2960, T> registry) {
        this.registry = registry;
    }

    public Registry() {
        this.registry = new HashMap<>();
    }

    public static <T> Registry<T> of(Map<class_2960, T> registry) {
        return new Registry<>(registry);
    }

    public Map<class_2960, T> getRegistry() {
        return this.registry;
    }

    public int size() {
        return this.registry.size();
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public boolean containsKey(class_2960 id) {
        return this.registry.containsKey(id);
    }

    public boolean containsValue(T object) {
        return this.registry.containsValue(object);
    }

    public Set<Map.Entry<class_2960, T>> entrySet() {
        return this.registry.entrySet();
    }

    public Set<class_2960> keySet() {
        return this.registry.keySet();
    }

    public Collection<T> values() {
        return this.registry.values();
    }

    @Nullable
    public T get(class_2960 id) {
        return this.registry.get(id);
    }

    public T getOrPut(class_2960 id, T object) {
        T object2 = this.get(id);

        if (object2 != null) {
            return object2;
        }

        this.put(id, object);
        return object;
    }

    public T put(class_2960 id, T object) {
        return this.registry.put(id, object);
    }

    public void putAll(Map<class_2960, T> registry) {
        this.registry.putAll(registry);
    }

    public T remove(class_2960 id) {
        return this.registry.remove(id);
    }

    public boolean remove(class_2960 id, T object) {
        return this.registry.remove(id, object);
    }

    public void clear() {
        this.registry.clear();
    }

    public T replace(class_2960 id, T object) {
        return this.registry.replace(id, object);
    }

    public boolean replace(class_2960 id, T oldRegistry, T newRegistry) {
        return this.registry.replace(id, oldRegistry, newRegistry);
    }

    public void replaceAll(BiFunction<class_2960, T, T> function) {
        this.registry.replaceAll(function);
    }
}
