/*
 * Decompiled with CFR 0.152.
 */
package xyz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.RpsGame;
import xyz.fynnlukah;

public class GameManager {
    private final fynnlukah plugin;
    private final Map<UUID, RpsGame> games = new ConcurrentHashMap<UUID, RpsGame>();

    public GameManager(fynnlukah plugin) {
        this.plugin = plugin;
    }

    public fynnlukah getPlugin() {
        return this.plugin;
    }

    public Optional<RpsGame> getGameFor(UUID player) {
        return this.games.values().stream().filter(g -> g.isPlayerInvolved(player)).findFirst();
    }

    public boolean hasGame(UUID player) {
        return this.getGameFor(player).isPresent();
    }

    public void addGame(final RpsGame game) {
        this.games.put(game.getId(), game);
        new BukkitRunnable(this){
            final /* synthetic */ GameManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!this.this$0.games.containsKey(game.getId())) {
                    this.cancel();
                    return;
                }
                if (game.isExpired()) {
                    game.onTimeout();
                    this.this$0.games.remove(game.getId());
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void removeGame(UUID id) {
        this.games.remove(id);
    }

    public void clearAll() {
        for (RpsGame g : new ArrayList<RpsGame>(this.games.values())) {
            g.refundAll();
            this.games.remove(g.getId());
        }
    }

    public static int countMaterial(Player player, Material material) {
        int count = 0;
        for (ItemStack stack : player.getInventory().getContents()) {
            if (stack == null || stack.getType() != material) continue;
            count += stack.getAmount();
        }
        return count;
    }

    public static int removeMaterial(Player player, Material material, int amount) {
        int remaining = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() != material) continue;
            int take = Math.min(stack.getAmount(), remaining);
            stack.setAmount(stack.getAmount() - take);
            remaining -= take;
            if (stack.getAmount() <= 0) {
                contents[i] = null;
            }
            if (remaining <= 0) break;
        }
        player.getInventory().setContents(contents);
        return amount - remaining;
    }

    public static void giveOrDrop(Player player, Material material, int amount) {
        ItemStack stack = new ItemStack(material, amount);
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{stack});
        if (!leftover.isEmpty()) {
            for (ItemStack s : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), s);
            }
        }
    }
}

