/*
 * Decompiled with CFR 0.152.
 */
package xyz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import xyz.GameManager;
import xyz.RpsGame;
import xyz.fynnlukah;

public class RpsCommand
implements CommandExecutor,
TabCompleter {
    private final GameManager manager;

    public RpsCommand(fynnlukah plugin, GameManager manager) {
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player p = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(p);
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "challenge": 
            case "c": {
                this.handleChallenge(p, args);
                break;
            }
            case "accept": 
            case "a": {
                this.handleAccept(p, args);
                break;
            }
            case "decline": 
            case "d": {
                this.handleDecline(p, args);
                break;
            }
            case "play": 
            case "p": {
                this.handlePlay(p, args);
                break;
            }
            case "cancel": {
                this.handleCancel(p, args);
                break;
            }
            default: {
                this.sendHelp(p);
            }
        }
        return true;
    }

    private void sendHelp(Player p) {
        p.sendMessage(String.valueOf(ChatColor.GREEN) + "RPS commands:");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/rps challenge <player> <amount> <iron|diamond>");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/rps accept");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/rps decline");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/rps play <rock|paper|scissors>");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/rps cancel");
    }

    private Material parseMaterial(String s) {
        return switch (s = s.toLowerCase(Locale.ROOT)) {
            case "iron", "iron_ingot" -> Material.IRON_INGOT;
            case "diamond" -> Material.DIAMOND;
            default -> null;
        };
    }

    private void handleChallenge(Player p, String[] args) {
        int amount;
        if (args.length < 4) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rps challenge <player> <amount> <iron|diamond>");
            return;
        }
        String targetName = args[1];
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null || !target.isOnline()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Player not online: " + targetName);
            return;
        }
        if (target.getUniqueId().equals(p.getUniqueId())) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You cannot challenge yourself.");
            return;
        }
        if (this.manager.hasGame(p.getUniqueId()) || this.manager.hasGame(target.getUniqueId())) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Either you or the target is already in a game.");
            return;
        }
        try {
            amount = Integer.parseInt(args[2]);
            if (amount <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount: " + args[2]);
            return;
        }
        Material mat = this.parseMaterial(args[3]);
        if (mat == null) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Invalid material. Use iron or diamond.");
            return;
        }
        int have = GameManager.countMaterial(p, mat);
        if (have < amount) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough " + mat.name().toLowerCase() + ". You have: " + have);
            return;
        }
        int removed = GameManager.removeMaterial(p, mat, amount);
        if (removed < amount) {
            GameManager.giveOrDrop(p, mat, removed);
            p.sendMessage(String.valueOf(ChatColor.RED) + "Could not remove the wager items from your inventory.");
            return;
        }
        RpsGame game = new RpsGame(this.manager, p, target, mat, amount);
        this.manager.addGame(game);
        p.sendMessage(String.valueOf(ChatColor.GREEN) + "Challenge sent to " + target.getName() + " for " + amount + " " + mat.name().toLowerCase() + ".");
        target.sendMessage(String.valueOf(ChatColor.GOLD) + p.getName() + " has challenged you to rock-paper-scissors for " + amount + " " + mat.name().toLowerCase() + ". Type /rps accept to accept or /rps decline to decline.");
    }

    private void handleAccept(Player p, String[] args) {
        Optional<RpsGame> opt = this.manager.getGameFor(p.getUniqueId());
        if (opt.isEmpty()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending challenge to accept.");
            return;
        }
        RpsGame game = opt.get();
        if (game.isAccepted()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "This game is already accepted.");
            return;
        }
        if (!game.isPlayerInvolved(p.getUniqueId())) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You're not involved in this game.");
            return;
        }
        boolean ok = game.accept(p);
        if (!ok) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Unable to accept the challenge (missing items?).");
        }
    }

    private void handleDecline(Player p, String[] args) {
        Optional<RpsGame> opt = this.manager.getGameFor(p.getUniqueId());
        if (opt.isEmpty()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending challenge to decline.");
            return;
        }
        RpsGame game = opt.get();
        if (!game.isPlayerInvolved(p.getUniqueId())) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You're not involved in this game.");
            return;
        }
        if (game.isAccepted()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "This challenge was already accepted; cannot decline.");
            return;
        }
        game.refundChallenger();
        Player c = Bukkit.getPlayer((UUID)game.getChallengerId());
        if (c != null) {
            c.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your challenge was declined by " + p.getName() + ". Wager refunded.");
        }
        p.sendMessage(String.valueOf(ChatColor.YELLOW) + "You declined the challenge from " + game.getChallengerName() + ".");
        this.manager.removeGame(game.getId());
    }

    private void handlePlay(Player p, String[] args) {
        RpsGame.Choice cchoice;
        String choice;
        if (args.length < 2) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rps play <rock|paper|scissors>");
            return;
        }
        switch (choice = args[1].toLowerCase(Locale.ROOT)) {
            case "rock": {
                cchoice = RpsGame.Choice.ROCK;
                break;
            }
            case "paper": {
                cchoice = RpsGame.Choice.PAPER;
                break;
            }
            case "scissors": {
                cchoice = RpsGame.Choice.SCISSORS;
                break;
            }
            default: {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Invalid choice. Use rock, paper or scissors.");
                return;
            }
        }
        Optional<RpsGame> opt = this.manager.getGameFor(p.getUniqueId());
        if (opt.isEmpty()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You're not in an active game.");
            return;
        }
        RpsGame game = opt.get();
        if (!game.isAccepted()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "The game hasn't been accepted yet.");
            return;
        }
        boolean ok = game.playChoice(p, cchoice);
        if (!ok) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Unable to play your choice.");
        }
    }

    private void handleCancel(Player p, String[] args) {
        Optional<RpsGame> opt = this.manager.getGameFor(p.getUniqueId());
        if (opt.isEmpty()) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending game to cancel.");
            return;
        }
        RpsGame game = opt.get();
        boolean ok = game.cancelByChallenger(p);
        if (!ok) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Unable to cancel (maybe the game was accepted already).");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> out = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return out;
        }
        if (args.length == 1) {
            out.addAll(Arrays.asList("challenge", "accept", "decline", "play", "cancel"));
            return out;
        }
        String first = args[0].toLowerCase(Locale.ROOT);
        if ((first.equals("challenge") || first.equals("c")) && args.length == 2) {
            for (Player pl : Bukkit.getOnlinePlayers()) {
                out.add(pl.getName());
            }
            return out;
        }
        if ((first.equals("challenge") || first.equals("c")) && args.length == 4) {
            return Arrays.asList("iron", "diamond");
        }
        if ((first.equals("play") || first.equals("p")) && args.length == 2) {
            return Arrays.asList("rock", "paper", "scissors");
        }
        return out;
    }
}

