/*
 * Decompiled with CFR 0.152.
 */
package xyz;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import xyz.GameManager;

public class RpsGame {
    private final UUID id = UUID.randomUUID();
    private final UUID challengerId;
    private final String challengerName;
    private final UUID targetId;
    private final String targetName;
    private final Material wagerMaterial;
    private final int wagerAmount;
    private final GameManager manager;
    private final long createdAt = System.currentTimeMillis();
    private boolean accepted = false;
    private boolean completed = false;
    private final Map<UUID, Choice> choices = new HashMap<UUID, Choice>();
    private static final long TIMEOUT_MS = 60000L;

    public RpsGame(GameManager manager, Player challenger, Player target, Material wagerMaterial, int wagerAmount) {
        this.manager = manager;
        this.challengerId = challenger.getUniqueId();
        this.challengerName = challenger.getName();
        this.targetId = target.getUniqueId();
        this.targetName = target.getName();
        this.wagerMaterial = wagerMaterial;
        this.wagerAmount = wagerAmount;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getChallengerId() {
        return this.challengerId;
    }

    public String getChallengerName() {
        return this.challengerName;
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public boolean isPlayerInvolved(UUID player) {
        return this.challengerId.equals(player) || this.targetId.equals(player);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.createdAt > 60000L;
    }

    public void onTimeout() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        Player c = this.manager.getPlugin().getServer().getPlayer(this.challengerId);
        Player t = this.manager.getPlugin().getServer().getPlayer(this.targetId);
        if (!this.accepted) {
            if (c != null) {
                c.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your challenge to " + this.targetName + " timed out and was refunded.");
            }
            this.refundChallenger();
            if (t != null) {
                t.sendMessage(String.valueOf(ChatColor.YELLOW) + "A challenge from " + this.challengerName + " expired.");
            }
        } else {
            if (c != null) {
                c.sendMessage(String.valueOf(ChatColor.YELLOW) + "RPS game vs " + this.targetName + " timed out; refunding wagers.");
            }
            if (t != null) {
                t.sendMessage(String.valueOf(ChatColor.YELLOW) + "RPS game vs " + this.challengerName + " timed out; refunding wagers.");
            }
            this.refundAll();
        }
        this.manager.removeGame(this.id);
    }

    public void refundChallenger() {
        Player c = this.manager.getPlugin().getServer().getPlayer(this.challengerId);
        if (c != null) {
            GameManager.giveOrDrop(c, this.wagerMaterial, this.wagerAmount);
        }
    }

    public void refundAll() {
        Player c = this.manager.getPlugin().getServer().getPlayer(this.challengerId);
        Player t = this.manager.getPlugin().getServer().getPlayer(this.targetId);
        if (c != null) {
            GameManager.giveOrDrop(c, this.wagerMaterial, this.wagerAmount);
        }
        if (t != null) {
            GameManager.giveOrDrop(t, this.wagerMaterial, this.wagerAmount);
        }
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean accept(Player accepter) {
        if (!this.targetId.equals(accepter.getUniqueId())) {
            return false;
        }
        int have = GameManager.countMaterial(accepter, this.wagerMaterial);
        if (have < this.wagerAmount) {
            return false;
        }
        int removed = GameManager.removeMaterial(accepter, this.wagerMaterial, this.wagerAmount);
        if (removed < this.wagerAmount) {
            if (removed > 0) {
                GameManager.giveOrDrop(accepter, this.wagerMaterial, removed);
            }
            return false;
        }
        this.accepted = true;
        Player c = this.manager.getPlugin().getServer().getPlayer(this.challengerId);
        if (c != null) {
            c.sendMessage(String.valueOf(ChatColor.GREEN) + "Your challenge to " + this.targetName + " was accepted!");
        }
        accepter.sendMessage(String.valueOf(ChatColor.GREEN) + "You accepted the challenge from " + this.challengerName + "!");
        return true;
    }

    public boolean cancelByChallenger(Player player) {
        if (!this.challengerId.equals(player.getUniqueId())) {
            return false;
        }
        if (this.accepted) {
            return false;
        }
        this.completed = true;
        GameManager.giveOrDrop(player, this.wagerMaterial, this.wagerAmount);
        Player t = this.manager.getPlugin().getServer().getPlayer(this.targetId);
        if (t != null) {
            t.sendMessage(String.valueOf(ChatColor.YELLOW) + "Challenge from " + this.challengerName + " was cancelled.");
        }
        this.manager.removeGame(this.id);
        return true;
    }

    public String describeWager() {
        return this.wagerAmount + "x " + this.wagerMaterial.name().toLowerCase();
    }

    public boolean playChoice(Player player, Choice choice) {
        if (!this.isPlayerInvolved(player.getUniqueId())) {
            return false;
        }
        if (!this.accepted) {
            return false;
        }
        if (this.completed) {
            return false;
        }
        this.choices.put(player.getUniqueId(), choice);
        Player other = this.manager.getPlugin().getServer().getPlayer(this.opponentOf(player.getUniqueId()));
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "You played " + choice.name().toLowerCase() + ".");
        if (other != null) {
            other.sendMessage(String.valueOf(ChatColor.AQUA) + player.getName() + " has made their choice.");
        }
        if (this.choices.size() >= 2) {
            this.resolve();
        }
        return true;
    }

    private UUID opponentOf(UUID player) {
        if (player.equals(this.challengerId)) {
            return this.targetId;
        }
        return this.challengerId;
    }

    private void resolve() {
        Choice c1 = this.choices.get(this.challengerId);
        Choice c2 = this.choices.get(this.targetId);
        Player c = this.manager.getPlugin().getServer().getPlayer(this.challengerId);
        Player t = this.manager.getPlugin().getServer().getPlayer(this.targetId);
        if (c1 == null || c2 == null) {
            this.refundAll();
            if (c != null) {
                c.sendMessage(String.valueOf(ChatColor.YELLOW) + "One of the players did not play in time. Wagers refunded.");
            }
            if (t != null) {
                t.sendMessage(String.valueOf(ChatColor.YELLOW) + "One of the players did not play in time. Wagers refunded.");
            }
            this.manager.removeGame(this.id);
            this.completed = true;
            return;
        }
        if (c1 == c2) {
            if (c != null) {
                c.sendMessage(String.valueOf(ChatColor.YELLOW) + "It's a tie! Both players refunded.");
            }
            if (t != null) {
                t.sendMessage(String.valueOf(ChatColor.YELLOW) + "It's a tie! Both players refunded.");
            }
            this.refundAll();
            this.manager.removeGame(this.id);
            this.completed = true;
            return;
        }
        boolean challengerWins = this.wins(c1, c2);
        if (challengerWins) {
            if (c != null) {
                GameManager.giveOrDrop(c, this.wagerMaterial, this.wagerAmount * 2);
            }
            if (c != null) {
                c.sendMessage(String.valueOf(ChatColor.GOLD) + "You beat " + this.targetName + " and won " + this.describeWager() + "!");
            }
            if (t != null) {
                t.sendMessage(String.valueOf(ChatColor.RED) + "You lost to " + this.challengerName + ".");
            }
        } else {
            if (t != null) {
                GameManager.giveOrDrop(t, this.wagerMaterial, this.wagerAmount * 2);
            }
            if (t != null) {
                t.sendMessage(String.valueOf(ChatColor.GOLD) + "You beat " + this.challengerName + " and won " + this.describeWager() + "!");
            }
            if (c != null) {
                c.sendMessage(String.valueOf(ChatColor.RED) + "You lost to " + this.targetName + ".");
            }
        }
        this.manager.removeGame(this.id);
        this.completed = true;
    }

    private boolean wins(Choice a, Choice b) {
        if (a == Choice.ROCK && b == Choice.SCISSORS) {
            return true;
        }
        if (a == Choice.PAPER && b == Choice.ROCK) {
            return true;
        }
        return a == Choice.SCISSORS && b == Choice.PAPER;
    }

    public static enum Choice {
        ROCK,
        PAPER,
        SCISSORS;

    }
}

