/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.commandsplus.network;

import java.util.function.Supplier;
import net.mcreator.commandsplus.CommandsPlusMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class CommandsPlusModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"commands_plus");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CommandsPlusMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"commands_plus", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        public boolean has_pig = false;
        public boolean has_chicken = false;
        public boolean raining = false;
        public String rain_type = "none";
        public boolean torchering = false;
        public String torcher_type = "none";
        public BlockState block_type = Blocks.AIR.defaultBlockState();
        public boolean controlling = false;
        public double homeX = 0.0;
        public double homeY = 0.0;
        public double homeZ = 0.0;
        public boolean hasHome = false;
        public double lastDeathX = 0.0;
        public double lastDeathY = 0.0;
        public double lastDeathZ = 0.0;
        public boolean morphed = false;
        public String entity_morph_uuid = "";
        public boolean coord_display = true;
        public String whenjoined = "\"\"";
        public String whenleft = "\"\"";

        public void serialize(ValueOutput output) {
            output.putBoolean("has_pig", this.has_pig);
            output.putBoolean("has_chicken", this.has_chicken);
            output.putBoolean("raining", this.raining);
            output.putString("rain_type", this.rain_type);
            output.putBoolean("torchering", this.torchering);
            output.putString("torcher_type", this.torcher_type);
            output.store("block_type", BlockState.CODEC, (Object)this.block_type);
            output.putBoolean("controlling", this.controlling);
            output.putDouble("homeX", this.homeX);
            output.putDouble("homeY", this.homeY);
            output.putDouble("homeZ", this.homeZ);
            output.putBoolean("hasHome", this.hasHome);
            output.putDouble("lastDeathX", this.lastDeathX);
            output.putDouble("lastDeathY", this.lastDeathY);
            output.putDouble("lastDeathZ", this.lastDeathZ);
            output.putBoolean("morphed", this.morphed);
            output.putString("entity_morph_uuid", this.entity_morph_uuid);
            output.putBoolean("coord_display", this.coord_display);
            output.putString("whenjoined", this.whenjoined);
            output.putString("whenleft", this.whenleft);
        }

        public void deserialize(ValueInput input) {
            this.has_pig = input.getBooleanOr("has_pig", false);
            this.has_chicken = input.getBooleanOr("has_chicken", false);
            this.raining = input.getBooleanOr("raining", false);
            this.rain_type = input.getStringOr("rain_type", "");
            this.torchering = input.getBooleanOr("torchering", false);
            this.torcher_type = input.getStringOr("torcher_type", "");
            this.block_type = input.read("block_type", BlockState.CODEC).orElse(Blocks.AIR.defaultBlockState());
            this.controlling = input.getBooleanOr("controlling", false);
            this.homeX = input.getDoubleOr("homeX", 0.0);
            this.homeY = input.getDoubleOr("homeY", 0.0);
            this.homeZ = input.getDoubleOr("homeZ", 0.0);
            this.hasHome = input.getBooleanOr("hasHome", false);
            this.lastDeathX = input.getDoubleOr("lastDeathX", 0.0);
            this.lastDeathY = input.getDoubleOr("lastDeathY", 0.0);
            this.lastDeathZ = input.getDoubleOr("lastDeathZ", 0.0);
            this.morphed = input.getBooleanOr("morphed", false);
            this.entity_morph_uuid = input.getStringOr("entity_morph_uuid", "");
            this.coord_display = input.getBooleanOr("coord_display", false);
            this.whenjoined = input.getStringOr("whenjoined", "");
            this.whenleft = input.getStringOr("whenleft", "");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.has_pig = original.has_pig;
            clone.has_chicken = original.has_chicken;
            clone.raining = original.raining;
            clone.rain_type = original.rain_type;
            clone.torchering = original.torchering;
            clone.torcher_type = original.torcher_type;
            clone.block_type = original.block_type;
            clone.controlling = original.controlling;
            clone.homeX = original.homeX;
            clone.homeY = original.homeY;
            clone.homeZ = original.homeZ;
            clone.hasHome = original.hasHome;
            clone.lastDeathX = original.lastDeathX;
            clone.lastDeathY = original.lastDeathY;
            clone.lastDeathZ = original.lastDeathZ;
            clone.morphed = original.morphed;
            clone.entity_morph_uuid = original.entity_morph_uuid;
            clone.coord_display = original.coord_display;
            clone.whenjoined = original.whenjoined;
            clone.whenleft = original.whenleft;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

