/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.commandsplus.procedures;

import javax.annotation.Nullable;
import net.mcreator.commandsplus.CommandsPlusMod;
import net.mcreator.commandsplus.network.CommandsPlusModVariables;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(value={Dist.CLIENT})
public class PlayerThrowEggProcedure {
    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new PlayerThrowEggMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PlayerThrowEggProcedure.execute((Entity)event.getEntity());
    }

    public static void execute(Entity entity) {
        PlayerThrowEggProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        Entity _shootFrom;
        Level projectileLevel;
        if (entity == null) {
            return;
        }
        if (((CommandsPlusModVariables.PlayerVariables)entity.getData(CommandsPlusModVariables.PLAYER_VARIABLES)).has_chicken && !(projectileLevel = (_shootFrom = entity).level()).isClientSide()) {
            Projectile _entityToSpawn = PlayerThrowEggProcedure.initProjectileProperties((Projectile)new ThrownEgg(EntityType.EGG, projectileLevel), entity, Vec3.ZERO);
            _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
            _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 1.0f, 0.0f);
            projectileLevel.addFreshEntity((Entity)_entityToSpawn);
        }
    }

    private static Projectile initProjectileProperties(Projectile entityToSpawn, Entity shooter, Vec3 acceleration) {
        entityToSpawn.setOwner(shooter);
        if (!Vec3.ZERO.equals((Object)acceleration)) {
            entityToSpawn.setDeltaMovement(acceleration);
            entityToSpawn.hasImpulse = true;
        }
        return entityToSpawn;
    }

    @EventBusSubscriber
    public record PlayerThrowEggMessage() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerThrowEggMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"commands_plus", (String)"procedure_player_throw_egg"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerThrowEggMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {}, buffer -> new PlayerThrowEggMessage());

        public CustomPacketPayload.Type<PlayerThrowEggMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerThrowEggMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.SERVERBOUND) {
                context.enqueueWork(() -> {
                    if (!context.player().level().hasChunkAt(context.player().blockPosition())) {
                        return;
                    }
                    PlayerThrowEggProcedure.execute((Entity)context.player());
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }

        @SubscribeEvent
        public static void registerMessage(FMLCommonSetupEvent event) {
            CommandsPlusMod.addNetworkMessage(TYPE, STREAM_CODEC, PlayerThrowEggMessage::handleData);
        }
    }
}

