/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.commandsplus.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.commandsplus.init.CommandsPlusModScreens;
import net.mcreator.commandsplus.network.CommandGuiButtonMessage;
import net.mcreator.commandsplus.world.inventory.CommandGuiMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class CommandGuiScreen
extends AbstractContainerScreen<CommandGuiMenu>
implements CommandsPlusModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox command;
    Button button_execute;

    public CommandGuiScreen(CommandGuiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("command")) {
                this.command.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.command.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.command.isFocused()) {
            return this.command.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String commandValue = this.command.getValue();
        super.resize(minecraft, width, height);
        this.command.setValue(commandValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
        this.command = new EditBox(this.font, this.leftPos + 30, this.topPos + 68, 118, 18, (Component)Component.translatable((String)"gui.commands_plus.command_gui.command"));
        this.command.setMaxLength(8192);
        this.command.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((CommandGuiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "command", content, false);
            }
        });
        this.command.setHint((Component)Component.translatable((String)"gui.commands_plus.command_gui.command"));
        this.addWidget((GuiEventListener)this.command);
        this.button_execute = Button.builder((Component)Component.translatable((String)"gui.commands_plus.command_gui.button_execute"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CommandGuiButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CommandGuiButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 61, this.topPos + 96, 61, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_execute);
    }
}

