/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectinsights.client.handler;

import fuzs.effectinsights.EffectInsights;
import fuzs.effectinsights.client.gui.tooltip.MobEffectTooltipLines;
import fuzs.effectinsights.config.ClientConfig;
import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.Nullable;

public class EffectWidgetHandler {
    @Nullable
    private static List<Component> tooltipLines;

    public static EventResult onInventoryMobEffects(Screen screen, int availableSpace, MutableBoolean smallWidgets, MutableInt horizontalOffset) {
        MobEffectInstance mobEffect;
        if (!((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.widgetTooltips()) {
            return EventResult.PASS;
        }
        if (!(screen instanceof AbstractContainerScreen)) {
            return EventResult.PASS;
        }
        AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
        if (EffectWidgetHandler.isInWidgetsColumn(horizontalOffset.getAsInt(), smallWidgets.getAsBoolean()) && (mobEffect = EffectWidgetHandler.getMobEffectInRow(abstractContainerScreen)) != null) {
            tooltipLines = MobEffectTooltipLines.getMobEffectWidgetTooltipLines(mobEffect);
        }
        return EventResult.PASS;
    }

    public static void onAfterBackground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.widgetTooltips()) {
            return;
        }
        if (tooltipLines != null) {
            guiGraphics.setTooltipForNextFrame(screen.getFont(), tooltipLines, Optional.empty(), mouseX, mouseY);
            tooltipLines = null;
        }
    }

    private static boolean isInWidgetsColumn(int horizontalOffset, boolean smallWidgets) {
        int mouseX = ScreenHelper.getMouseX();
        int widgetWidth = !smallWidgets ? 121 : 33;
        return mouseX >= horizontalOffset && mouseX <= horizontalOffset + widgetWidth;
    }

    private static MobEffectInstance getMobEffectInRow(AbstractContainerScreen<?> screen) {
        int mouseY = ScreenHelper.getMouseY();
        int posY = screen.topPos;
        Collection<MobEffectInstance> mobEffects = EffectWidgetHandler.getVisibleMobEffects();
        int verticalOffset = EffectWidgetHandler.getVerticalOffset(mobEffects);
        MobEffectInstance hoveredMobEffect = null;
        for (MobEffectInstance mobEffect : mobEffects) {
            if (mouseY >= posY && mouseY <= posY + verticalOffset) {
                hoveredMobEffect = mobEffect;
            }
            posY += verticalOffset;
        }
        return hoveredMobEffect;
    }

    private static Collection<MobEffectInstance> getVisibleMobEffects() {
        return Minecraft.getInstance().player.getActiveEffects().stream().filter(ScreenHelper::isEffectVisibleInInventory).sorted().toList();
    }

    private static int getVerticalOffset(Collection<MobEffectInstance> mobEffects) {
        if (mobEffects.size() > 5) {
            return 132 / (mobEffects.size() - 1);
        }
        return 33;
    }

    public static void onGatherEffectScreenTooltip(AbstractContainerScreen<?> screen, MobEffectInstance mobEffectInstance, List<Component> tooltipLines) {
        if (((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectWidgetTooltips.widgetTooltips()) {
            tooltipLines.clear();
        }
    }
}

