/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectinsights.client.handler;

import fuzs.effectinsights.EffectInsights;
import fuzs.effectinsights.config.ClientConfig;
import fuzs.tooltipinsights.api.v1.client.handler.TooltipDescriptionsHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FoodTooltipHandler {
    public static void onItemTooltip(class_1799 itemStack, List<class_2561> tooltipLines, class_1792.class_9635 tooltipContext, @Nullable class_1657 player, class_1836 tooltipFlag) {
        if (!((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectItemTooltips.foodEffectTooltips) {
            return;
        }
        if (itemStack.method_57826(class_9334.field_53964)) {
            ArrayList<class_10132> consumeEffects = new ArrayList<class_10132>();
            for (class_10134 consumeEffect : ((class_10124)itemStack.method_58694(class_9334.field_53964)).comp_3089()) {
                if (!(consumeEffect instanceof class_10132)) continue;
                class_10132 applyStatusEffectsConsumeEffect = (class_10132)consumeEffect;
                consumeEffects.add(applyStatusEffectsConsumeEffect);
            }
            if (!consumeEffects.isEmpty()) {
                Set<String> translationKeys = FoodTooltipHandler.getAllTranslationKeys(tooltipLines);
                ArrayList<class_2561> potionLines = new ArrayList<class_2561>();
                ArrayList<class_2561> attributeLines = new ArrayList<class_2561>();
                for (class_10132 consumeEffect : consumeEffects) {
                    for (class_1293 mobEffectInstance : consumeEffect.comp_3094()) {
                        if (translationKeys.contains(mobEffectInstance.method_5586())) continue;
                        FoodTooltipHandler.collectPotionTooltipLines(mobEffectInstance, tooltipContext.method_59531(), consumeEffect.comp_3095(), potionLines, attributeLines);
                    }
                }
                FoodTooltipHandler.addPotionTooltipLines(tooltipLines, potionLines, attributeLines);
            }
        }
    }

    private static Set<String> getAllTranslationKeys(List<class_2561> tooltipLines) {
        return tooltipLines.stream().mapMulti((component, consumer) -> TooltipDescriptionsHandler.modifyTranslatableContents((class_2561)component, UnaryOperator.identity(), (translatableContents, contentsGatherer) -> {
            consumer.accept(translatableContents);
            return false;
        })).map(class_2588::method_11022).collect(Collectors.toSet());
    }

    private static void collectPotionTooltipLines(class_1293 mobEffectInstance, float tickRate, float probability, List<class_2561> potionLines, List<class_2561> attributeLines) {
        ArrayList<class_5250> potionTooltip = new ArrayList<class_5250>();
        class_1844.method_8065(Collections.singleton(mobEffectInstance), potionTooltip::add, (float)1.0f, (float)tickRate);
        if (!potionTooltip.isEmpty()) {
            int index;
            if (probability != 1.0f) {
                String s = class_3532.method_15375((float)(probability * 100.0f)) + "%";
                potionTooltip.set(0, class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{potionTooltip.getFirst(), s}).method_27692(class_124.field_1065));
            }
            if ((index = potionTooltip.indexOf(class_5244.field_39003)) != -1) {
                potionLines.addAll(potionTooltip.subList(0, index));
                attributeLines.addAll(potionTooltip.subList(index + 1, potionTooltip.size()));
            } else {
                potionLines.addAll(potionTooltip);
            }
        }
    }

    private static void addPotionTooltipLines(List<class_2561> tooltipLines, List<class_2561> potionLines, List<class_2561> attributeLines) {
        if (tooltipLines.isEmpty()) {
            tooltipLines.addAll(potionLines);
            if (!attributeLines.isEmpty()) {
                tooltipLines.add(class_5244.field_39003);
                tooltipLines.addAll(attributeLines);
            }
        } else {
            if (!attributeLines.isEmpty()) {
                tooltipLines.addAll(1, attributeLines);
                tooltipLines.add(1, class_5244.field_39003);
            }
            tooltipLines.addAll(1, potionLines);
        }
    }
}

