/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium;

import com.google.common.base.Preconditions;
import com.noxcrew.noxesium.NoxesiumModule;
import com.noxcrew.noxesium.NoxesiumPlatformHook;
import com.noxcrew.noxesium.api.protocol.ClientSettings;
import com.noxcrew.noxesium.config.NoxesiumConfig;
import com.noxcrew.noxesium.feature.CustomRenderTypes;
import com.noxcrew.noxesium.feature.TeamGlowHotkeys;
import com.noxcrew.noxesium.feature.entity.ExtraEntityData;
import com.noxcrew.noxesium.feature.entity.ExtraEntityDataModule;
import com.noxcrew.noxesium.feature.entity.QibBehaviorModule;
import com.noxcrew.noxesium.feature.entity.SpatialDebuggingRenderer;
import com.noxcrew.noxesium.feature.entity.SpatialInteractionEntityTree;
import com.noxcrew.noxesium.feature.rule.ServerRuleModule;
import com.noxcrew.noxesium.feature.rule.ServerRules;
import com.noxcrew.noxesium.feature.skull.SkullFontModule;
import com.noxcrew.noxesium.feature.sounds.NoxesiumSoundModule;
import com.noxcrew.noxesium.network.NoxesiumPacketHandling;
import com.noxcrew.noxesium.network.NoxesiumPackets;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientInformationPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientSettingsPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_315;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoxesiumMod {
    private static NoxesiumMod instance;
    private static NoxesiumPlatformHook platform;
    private final NoxesiumConfig config;
    private final Logger logger = LoggerFactory.getLogger((String)"Noxesium");
    private final Map<Class<? extends NoxesiumModule>, NoxesiumModule> modules = new HashMap<Class<? extends NoxesiumModule>, NoxesiumModule>();
    private int currentMaxProtocol = 18;
    private boolean initialized = false;

    public static NoxesiumMod getInstance() {
        return instance;
    }

    public static NoxesiumPlatformHook getPlatform() {
        return platform;
    }

    public NoxesiumMod(NoxesiumPlatformHook platformHook) {
        instance = this;
        platform = platformHook;
        this.config = NoxesiumConfig.load();
        NoxesiumPackets.registerPackets("universal");
        instance.registerModule(new ServerRuleModule());
        instance.registerModule(new SkullFontModule());
        instance.registerModule(new NoxesiumSoundModule());
        instance.registerModule(new TeamGlowHotkeys());
        instance.registerModule(new NoxesiumPacketHandling());
        instance.registerModule(new ExtraEntityDataModule());
        instance.registerModule(new QibBehaviorModule());
        instance.registerModule(new SpatialDebuggingRenderer());
        class_1921 ignored = ServerRules.DISABLE_SPIN_ATTACK_COLLISIONS;
        ignored = ExtraEntityData.DISABLE_BUBBLES;
        ignored = CustomRenderTypes.linesNoDepth();
        Thread backgroundTaskThread = new Thread("Noxesium Background Task Thread"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            SpatialInteractionEntityTree.rebuild();
                            Thread.sleep(20L);
                        }
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    catch (Exception ex) {
                        NoxesiumMod.this.logger.error("Caught exception from Noxesium Background Task Thread", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
        };
        backgroundTaskThread.setDaemon(true);
        backgroundTaskThread.start();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NoxesiumConfig getConfig() {
        return this.config;
    }

    public void registerModule(NoxesiumModule module) {
        this.modules.put(module.getClass(), module);
        module.onStartup();
        for (String group : NoxesiumPackets.getRegisteredGroups()) {
            module.onGroupRegistered(group);
        }
    }

    @NotNull
    public <T extends NoxesiumModule> T getModule(Class<T> clazz) {
        return (T)((NoxesiumModule)Preconditions.checkNotNull((Object)this.modules.get(clazz), (Object)("Could not get module " + clazz.getSimpleName())));
    }

    public Collection<NoxesiumModule> getAllModules() {
        return this.modules.values();
    }

    public int getMaxProtocolVersion() {
        return this.currentMaxProtocol;
    }

    public void setServerVersion(int maxProtocolVersion) {
        this.currentMaxProtocol = maxProtocolVersion;
    }

    public boolean initialize() {
        if (this.initialized) {
            return false;
        }
        if (!NoxesiumPackets.canSend(NoxesiumPackets.SERVER_CLIENT_INFO)) {
            return false;
        }
        if (class_310.method_1551().method_1562() != null) {
            this.initialized = true;
            new ServerboundClientInformationPacket(18, NoxesiumMod.getPlatform().getNoxesiumVersion()).send();
            NoxesiumMod.syncGuiScale();
            this.modules.values().forEach(NoxesiumModule::onJoinServer);
            return true;
        }
        return false;
    }

    public boolean uninitialize() {
        if (!this.initialized) {
            return false;
        }
        this.currentMaxProtocol = 18;
        this.initialized = false;
        this.modules.values().forEach(NoxesiumModule::onQuitServer);
        NoxesiumPackets.unregisterPackets();
        return true;
    }

    public static void syncGuiScale() {
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        class_315 options = class_310.method_1551().field_1690;
        new ServerboundClientSettingsPacket(new ClientSettings(((Integer)options.method_42474().method_41753()).intValue(), (double)window.method_4495(), window.method_4486(), window.method_4502(), class_310.method_1551().method_1573(), ((Boolean)options.method_42446().method_41753()).booleanValue(), ((Double)options.method_48191().method_41753()).doubleValue())).send();
    }
}

