/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.noxcrew.noxesium.NoxesiumMod;
import com.noxcrew.noxesium.api.config.BooleanOrDefault;
import com.noxcrew.noxesium.api.config.MapLocation;
import com.noxcrew.noxesium.feature.rule.ServerRules;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class NoxesiumConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean resetToggleKeys = false;
    public BooleanOrDefault renderMapsInUi = BooleanOrDefault.DEFAULT;
    public boolean showFpsOverlay = false;
    public boolean showGameTimeOverlay = false;
    public boolean enableQibSystemDebugging = false;
    public boolean showGlowingSettings = false;
    public boolean dumpIncomingPackets = false;
    public boolean dumpOutgoingPackets = false;
    public boolean printPacketExceptions = false;
    public boolean debugScoreboardTeams = false;
    public boolean showCullingBoxes = false;
    public double mapUiSize = 0.8;
    public MapLocation mapUiLocation = MapLocation.TOP;

    public boolean shouldRenderMapsInUi() {
        if (ServerRules.DISABLE_MAP_UI.getValue().booleanValue()) {
            return false;
        }
        if (this.renderMapsInUi == BooleanOrDefault.DEFAULT) {
            return ServerRules.SHOW_MAP_IN_UI.getValue();
        }
        return this.renderMapsInUi == BooleanOrDefault.TRUE;
    }

    public static NoxesiumConfig load() {
        Path file = NoxesiumConfig.getConfigFile();
        if (Files.exists(file, new LinkOption[0])) {
            NoxesiumConfig noxesiumConfig;
            FileReader reader = new FileReader(file.toFile());
            try {
                noxesiumConfig = (NoxesiumConfig)GSON.fromJson((Reader)reader, NoxesiumConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            reader.close();
            return noxesiumConfig;
        }
        return new NoxesiumConfig();
    }

    public void save() {
        try {
            Files.writeString(NoxesiumConfig.getConfigFile(), (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static Path getConfigFile() {
        return NoxesiumMod.getPlatform().getConfigDirectory().resolve("noxesium-config.json");
    }
}

