/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.entity;

import com.noxcrew.noxesium.NoxesiumMod;
import com.noxcrew.noxesium.NoxesiumModule;
import com.noxcrew.noxesium.api.qib.QibDefinition;
import com.noxcrew.noxesium.api.qib.QibEffect;
import com.noxcrew.noxesium.feature.entity.ExtraEntityData;
import com.noxcrew.noxesium.feature.entity.SpatialInteractionEntityTree;
import com.noxcrew.noxesium.feature.rule.ServerRules;
import com.noxcrew.noxesium.network.serverbound.ServerboundQibTriggeredPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class QibBehaviorModule
implements NoxesiumModule {
    private class_238 lastBoundingBox;
    private final Map<String, AtomicInteger> collidingWithTypes = new HashMap<String, AtomicInteger>();
    private final Map<class_1297, AtomicInteger> collidingWithEntities = new HashMap<class_1297, AtomicInteger>();
    private final Set<class_1297> triggeredJump = new HashSet<class_1297>();
    private final List<Pair<AtomicInteger, Triple<class_746, class_1297, QibEffect>>> pending = new ArrayList<Pair<AtomicInteger, Triple<class_746, class_1297, QibEffect>>>();

    @Override
    public void onStartup() {
        NoxesiumMod.getPlatform().registerTickEventHandler(() -> {
            if (((Map)ServerRules.QIB_BEHAVIORS.getValue()).isEmpty()) {
                return;
            }
            this.tickEffects();
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            HashSet<class_1297> entities = null;
            if (this.lastBoundingBox != null) {
                class_243 from = this.lastBoundingBox.method_64033();
                class_243 to = player.method_5829().method_64033();
                double diffX = to.field_1352 - from.field_1352;
                double diffY = to.field_1351 - from.field_1351;
                double diffZ = to.field_1350 - from.field_1350;
                double differenceLengthSquared = diffX * diffX + diffY * diffY + diffZ * diffZ;
                if (differenceLengthSquared >= 0.25) {
                    class_4048 dimensions = player.method_18377(player.method_18376());
                    class_243 currentLocation = from;
                    double differenceLength = Math.sqrt(differenceLengthSquared);
                    double factor = 0.5 / differenceLength;
                    double times = Math.ceil(differenceLength / 0.5) - 1.0;
                    int i = 0;
                    while ((double)i < times) {
                        currentLocation = currentLocation.method_1031(diffX * factor, diffY * factor, diffZ * factor);
                        if (entities == null) {
                            entities = SpatialInteractionEntityTree.findEntities(dimensions.method_30757(currentLocation));
                        } else {
                            entities.addAll(SpatialInteractionEntityTree.findEntities(dimensions.method_30757(currentLocation)));
                        }
                        ++i;
                    }
                }
            }
            if (entities == null) {
                entities = SpatialInteractionEntityTree.findEntities(player.method_5829());
            } else {
                entities.addAll(SpatialInteractionEntityTree.findEntities(player.method_5829()));
            }
            this.checkForCollisions(entities);
            this.lastBoundingBox = player.method_5829();
        });
    }

    private void sendPacket(String behavior, ServerboundQibTriggeredPacket.Type type, int entityId) {
        new ServerboundQibTriggeredPacket(behavior, type, entityId).send();
    }

    public void onPlayerJump(class_746 player) {
        if (player.method_5854() != null) {
            return;
        }
        for (class_1297 entity : this.collidingWithEntities.keySet()) {
            QibDefinition definition;
            if (this.triggeredJump.contains(entity) || !entity.noxesium$hasExtraData(ExtraEntityData.QIB_BEHAVIOR)) continue;
            String behavior = (String)entity.noxesium$getExtraData(ExtraEntityData.QIB_BEHAVIOR);
            Map knownBehaviors = (Map)ServerRules.QIB_BEHAVIORS.getValue();
            if (!knownBehaviors.containsKey(behavior) || (definition = (QibDefinition)knownBehaviors.get(behavior)).onJump() == null) continue;
            this.sendPacket(behavior, ServerboundQibTriggeredPacket.Type.JUMP, entity.method_5628());
            this.executeBehavior(player, entity, definition.onJump());
            this.triggeredJump.add(entity);
        }
    }

    private void tickEffects() {
        this.collidingWithTypes.values().forEach(AtomicInteger::incrementAndGet);
        this.collidingWithEntities.values().forEach(AtomicInteger::incrementAndGet);
        Iterator<Pair<AtomicInteger, Triple<class_746, class_1297, QibEffect>>> iterator = this.pending.iterator();
        while (iterator.hasNext()) {
            Pair<AtomicInteger, Triple<class_746, class_1297, QibEffect>> pair = iterator.next();
            if (((AtomicInteger)pair.getKey()).decrementAndGet() > 0) continue;
            Triple value = (Triple)pair.getValue();
            iterator.remove();
            this.executeBehavior((class_746)value.getLeft(), (class_1297)value.getMiddle(), (QibEffect)value.getRight());
        }
    }

    private void checkForCollisions(Set<class_1297> entities) {
        QibDefinition definition;
        Map knownBehaviors;
        String behavior;
        class_746 player = class_310.method_1551().field_1724;
        ArrayList<String> collidingTypes = new ArrayList<String>();
        for (class_1297 entity : entities) {
            if (!entity.noxesium$hasExtraData(ExtraEntityData.QIB_BEHAVIOR)) continue;
            behavior = (String)entity.noxesium$getExtraData(ExtraEntityData.QIB_BEHAVIOR);
            knownBehaviors = (Map)ServerRules.QIB_BEHAVIORS.getValue();
            if (!knownBehaviors.containsKey(behavior)) continue;
            definition = (QibDefinition)knownBehaviors.get(behavior);
            if ((!definition.triggerEnterLeaveOnSwitch() && !this.collidingWithTypes.containsKey(behavior) || definition.triggerEnterLeaveOnSwitch() && !this.collidingWithEntities.containsKey(entity)) && definition.onEnter() != null) {
                this.sendPacket(behavior, ServerboundQibTriggeredPacket.Type.ENTER, entity.method_5628());
                this.executeBehavior(player, entity, definition.onEnter());
            }
            if (definition.whileInside() != null) {
                this.sendPacket(behavior, ServerboundQibTriggeredPacket.Type.INSIDE, entity.method_5628());
                this.executeBehavior(player, entity, definition.whileInside());
            }
            collidingTypes.add(behavior);
            this.collidingWithTypes.putIfAbsent(behavior, new AtomicInteger());
            this.collidingWithEntities.putIfAbsent(entity, new AtomicInteger());
        }
        this.collidingWithTypes.keySet().retainAll(collidingTypes);
        Iterator<class_1297> iterator = this.collidingWithEntities.keySet().iterator();
        while (iterator.hasNext()) {
            class_1297 collision = iterator.next();
            if (entities.contains(collision)) continue;
            iterator.remove();
            this.triggeredJump.remove(collision);
            if (!collision.noxesium$hasExtraData(ExtraEntityData.QIB_BEHAVIOR)) continue;
            behavior = (String)collision.noxesium$getExtraData(ExtraEntityData.QIB_BEHAVIOR);
            knownBehaviors = (Map)ServerRules.QIB_BEHAVIORS.getValue();
            if (!knownBehaviors.containsKey(behavior) || ((definition = (QibDefinition)knownBehaviors.get(behavior)).triggerEnterLeaveOnSwitch() || this.collidingWithTypes.containsKey(behavior)) && (!definition.triggerEnterLeaveOnSwitch() || this.collidingWithEntities.containsKey(collision)) || definition.onLeave() == null) continue;
            this.sendPacket(behavior, ServerboundQibTriggeredPacket.Type.LEAVE, collision.method_5628());
            this.executeBehavior(player, collision, definition.onLeave());
        }
    }

    private void executeBehavior(class_746 player, class_1297 entity, QibEffect effect) {
        QibEffect qibEffect = effect;
        Objects.requireNonNull(qibEffect);
        QibEffect qibEffect2 = qibEffect;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QibEffect.Multiple.class, QibEffect.Stay.class, QibEffect.Wait.class, QibEffect.Conditional.class, QibEffect.PlaySound.class, QibEffect.GivePotionEffect.class, QibEffect.RemovePotionEffect.class, QibEffect.RemoveAllPotionEffects.class, QibEffect.Move.class, QibEffect.AddVelocity.class, QibEffect.SetVelocity.class, QibEffect.SetVelocityYawPitch.class, QibEffect.ModifyVelocity.class}, (Object)qibEffect2, n)) {
            case 0: {
                QibEffect.Multiple multiple = (QibEffect.Multiple)qibEffect2;
                for (QibEffect nested : multiple.effects()) {
                    this.executeBehavior(player, entity, nested);
                }
                break;
            }
            case 1: {
                int timeSpent;
                QibEffect.Stay stay = (QibEffect.Stay)qibEffect2;
                int n2 = timeSpent = stay.global() ? this.collidingWithTypes.getOrDefault(entity.noxesium$getExtraData(ExtraEntityData.QIB_BEHAVIOR), new AtomicInteger()).get() : this.collidingWithEntities.getOrDefault(entity, new AtomicInteger()).get();
                if (timeSpent < stay.ticks()) break;
                this.executeBehavior(player, entity, stay.effect());
                break;
            }
            case 2: {
                QibEffect.Wait wait = (QibEffect.Wait)qibEffect2;
                this.pending.add((Pair<AtomicInteger, Triple<class_746, class_1297, QibEffect>>)Pair.of((Object)new AtomicInteger(wait.ticks()), (Object)Triple.of((Object)player, (Object)entity, (Object)wait.effect())));
                break;
            }
            case 3: {
                boolean result;
                QibEffect.Conditional conditional = (QibEffect.Conditional)qibEffect2;
                switch (conditional.condition()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case IS_GLIDING: {
                        boolean bl = player.method_6128();
                        break;
                    }
                    case IS_RIPTIDING: {
                        boolean bl = player.method_6123();
                        break;
                    }
                    case IS_IN_AIR: {
                        boolean bl;
                        if (!player.method_24828()) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case IS_ON_GROUND: {
                        boolean bl = player.method_24828();
                        break;
                    }
                    case IS_IN_WATER: {
                        boolean bl = player.method_5799();
                        break;
                    }
                    case IS_IN_WATER_OR_RAIN: {
                        boolean bl = result = player.method_5721();
                    }
                }
                if (result != conditional.value()) break;
                this.executeBehavior(player, entity, conditional.effect());
                break;
            }
            case 4: {
                QibEffect.PlaySound playSound = (QibEffect.PlaySound)qibEffect2;
                player.method_37908().method_55116((class_1297)player, class_3414.method_47908((class_2960)class_2960.method_60655((String)playSound.namespace(), (String)playSound.path())), class_3419.field_15248, playSound.volume(), playSound.pitch());
                break;
            }
            case 5: {
                QibEffect.GivePotionEffect giveEffect = (QibEffect.GivePotionEffect)qibEffect2;
                class_6880.class_6883 type = class_7923.field_41174.method_10223(class_2960.method_60655((String)giveEffect.namespace(), (String)giveEffect.path())).orElse(null);
                player.noxesium$addClientsidePotionEffect(new class_1293((class_6880)type, giveEffect.duration(), giveEffect.amplifier(), giveEffect.ambient(), giveEffect.visible(), giveEffect.showIcon()));
                break;
            }
            case 6: {
                QibEffect.RemovePotionEffect removeEffect = (QibEffect.RemovePotionEffect)qibEffect2;
                player.noxesium$removeClientsidePotionEffect((class_6880)class_7923.field_41174.method_10223(class_2960.method_60655((String)removeEffect.namespace(), (String)removeEffect.path())).orElse(null));
                break;
            }
            case 7: {
                QibEffect.RemoveAllPotionEffects ignored = (QibEffect.RemoveAllPotionEffects)qibEffect2;
                player.noxesium$clearClientsidePotionEffects();
                break;
            }
            case 8: {
                QibEffect.Move move = (QibEffect.Move)qibEffect2;
                player.method_5784(class_1313.field_6308, new class_243(move.x(), move.y(), move.z()));
                break;
            }
            case 9: {
                QibEffect.AddVelocity addVelocity = (QibEffect.AddVelocity)qibEffect2;
                player.method_5762(addVelocity.x(), addVelocity.y(), addVelocity.z());
                break;
            }
            case 10: {
                QibEffect.SetVelocity setVelocity = (QibEffect.SetVelocity)qibEffect2;
                player.method_18800(setVelocity.x(), setVelocity.y(), setVelocity.z());
                break;
            }
            case 11: {
                QibEffect.SetVelocityYawPitch setVelocityYawPitch = (QibEffect.SetVelocityYawPitch)qibEffect2;
                double yawRad = Math.toRadians(setVelocityYawPitch.yaw() + (double)(setVelocityYawPitch.yawRelative() ? player.field_5982 : 0.0f));
                double pitchRad = Math.toRadians(setVelocityYawPitch.pitch() + (double)(setVelocityYawPitch.pitchRelative() ? player.field_6004 : 0.0f));
                double x = -Math.cos(pitchRad) * Math.sin(yawRad);
                double y = -Math.sin(pitchRad);
                double z = Math.cos(pitchRad) * Math.cos(yawRad);
                player.method_18800(Math.clamp(x * setVelocityYawPitch.strength(), -setVelocityYawPitch.limit(), setVelocityYawPitch.limit()), Math.clamp(y * setVelocityYawPitch.strength(), -setVelocityYawPitch.limit(), setVelocityYawPitch.limit()), Math.clamp(z * setVelocityYawPitch.strength(), -setVelocityYawPitch.limit(), setVelocityYawPitch.limit()));
                break;
            }
            case 12: {
                QibEffect.ModifyVelocity modifyVelocity = (QibEffect.ModifyVelocity)qibEffect2;
                class_243 current = player.method_18798();
                player.method_18800(modifyVelocity.xOp().apply(current.field_1352, modifyVelocity.x()), modifyVelocity.yOp().apply(current.field_1351, modifyVelocity.y()), modifyVelocity.zOp().apply(current.field_1350, modifyVelocity.z()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(effect));
            }
        }
    }
}

