/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.LargeBabyPanicGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.MajungasaurusAttackGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.PrehistoricNearestAttackableTargetGoal;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2EntityTags;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Majungasaurus
extends PrehistoricMob {
    public static final EntityDataAccessor<Integer> STEALTH_COOLDOWN = SynchedEntityData.m_135353_(Majungasaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState eyesAnimationState = new AnimationState();
    public final AnimationState biteRightAnimationState = new AnimationState();
    public final AnimationState biteLeftAnimationState = new AnimationState();
    public final AnimationState enterStealthAnimationState = new AnimationState();
    public final AnimationState stealthIdleAnimationState = new AnimationState();
    public final AnimationState exitStealthAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    private float stealthProgress;
    private float prevStealthProgress;
    private int biteTicks;

    public Majungasaurus(EntityType<? extends PrehistoricMob> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MajungasaurusAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LargeBabyPanicGoal(this, 1.7));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.MAJUNGASAURUS_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal<Majungasaurus>((PathfinderMob)this, Majungasaurus.class, 12.0f, 2.0, 2.0, this::avoidsParents){

            public boolean m_8036_() {
                return super.m_8036_() && Majungasaurus.this.m_6162_();
            }
        });
        this.f_21346_.m_25352_(1, new PrehistoricNearestAttackableTargetGoal<Majungasaurus>(this, Majungasaurus.class, 300, true, true, this::canCannibalize));
        this.f_21346_.m_25352_(2, new PrehistoricNearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 600, true, false, entity -> entity.m_6095_().m_204039_(UP2EntityTags.MAJUNGASAURUS_TARGETS)));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.19f).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float amount) {
        this.exitStealthInstantly();
        super.m_6475_(damageSource, amount);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.MAJUNGASAURUS_FOOD);
    }

    public float getStealthProgress(float partialTicks) {
        return (this.prevStealthProgress + (this.stealthProgress - this.prevStealthProgress) * partialTicks) * 0.05f;
    }

    public boolean canCannibalize(LivingEntity entity) {
        return this.m_6779_(entity) && (entity.m_21223_() < entity.m_21233_() * 0.5f || entity.m_6162_());
    }

    public boolean avoidsParents(LivingEntity entity) {
        Majungasaurus majungasaurus = (Majungasaurus)entity;
        return this.m_6162_() && !entity.m_6162_() && !majungasaurus.isMajungasaurusStealthMode();
    }

    @Override
    public boolean canPacifiy() {
        return true;
    }

    @Override
    public boolean isPacifyItem(ItemStack itemStack) {
        return itemStack.m_204117_(UP2ItemTags.PACIFIES_MAJUNGASAURUS);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevStealthProgress = this.stealthProgress;
        if (this.biteTicks > 0) {
            --this.biteTicks;
        }
        if (this.biteTicks == 0 && this.m_20089_() == UP2Poses.BITING.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.isMajungasaurusStealthMode() && this.stealthProgress < 20.0f) {
            this.stealthProgress += 1.0f;
        }
        if (!this.isMajungasaurusStealthMode() && this.stealthProgress > 0.0f) {
            this.stealthProgress -= 1.0f;
        }
        if (this.getStealthCooldown() > 0) {
            this.setStealthCooldown(this.getStealthCooldown() - 1);
        }
    }

    @Override
    public void setupAnimationStates() {
        if (this.biteTicks == 0 && (this.biteRightAnimationState.m_216984_() || this.biteLeftAnimationState.m_216984_())) {
            this.biteRightAnimationState.m_216973_();
            this.biteLeftAnimationState.m_216973_();
        }
        this.idleAnimationState.m_246184_(!this.isMajungasaurusStealthMode() && !this.m_20069_(), this.f_19797_);
        this.eyesAnimationState.m_246184_(this.getBehavior().equals(Behaviors.IDLE.getName()), this.f_19797_);
        this.swimmingAnimationState.m_246184_(!this.isMajungasaurusStealthMode() && this.m_20069_(), this.f_19797_);
        if (this.isMajungasaurusVisuallyStealthMode()) {
            this.exitStealthAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            if (this.isVisuallyStealthMode()) {
                this.enterStealthAnimationState.m_216982_(this.f_19797_);
                this.stealthIdleAnimationState.m_216973_();
            } else {
                this.enterStealthAnimationState.m_216973_();
                this.stealthIdleAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.stealthIdleAnimationState.m_216973_();
            this.enterStealthAnimationState.m_216973_();
            this.exitStealthAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    @Override
    public float getWalkAnimationSpeed() {
        return this.m_6162_() ? 2.0f : 4.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STEALTH_COOLDOWN, (Object)(60 + this.f_19796_.m_188503_(10)));
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("StealthCooldown", this.getStealthCooldown());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setStealthCooldown(compoundTag.m_128451_("StealthCooldown"));
    }

    public int getStealthCooldown() {
        return (Integer)this.f_19804_.m_135370_(STEALTH_COOLDOWN);
    }

    public void setStealthCooldown(int cooldown) {
        this.f_19804_.m_135381_(STEALTH_COOLDOWN, (Object)cooldown);
    }

    public void stealthCooldown() {
        this.f_19804_.m_135381_(STEALTH_COOLDOWN, (Object)(60 + this.f_19796_.m_188503_(10)));
    }

    public boolean isMajungasaurusStealthMode() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isMajungasaurusVisuallyStealthMode() {
        return this.getPoseTime() < 0L != this.isMajungasaurusStealthMode();
    }

    @Override
    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < 20L;
    }

    private boolean isVisuallyStealthMode() {
        return this.isMajungasaurusStealthMode() && this.getPoseTime() < 20L && this.getPoseTime() >= 0L;
    }

    public void enterStealth() {
        if (this.isMajungasaurusStealthMode()) {
            return;
        }
        this.m_20124_(UP2Poses.STEALTH.get());
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void exitStealth() {
        if (!this.isMajungasaurusStealthMode()) {
            return;
        }
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        this.stealthCooldown();
        this.m_6210_();
    }

    public void exitStealthInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
        this.stealthCooldown();
        this.m_6210_();
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == UP2Poses.BITING.get()) {
                if (this.m_217043_().m_188499_()) {
                    this.biteRightAnimationState.m_216977_(this.f_19797_);
                }
                this.biteLeftAnimationState.m_216977_(this.f_19797_);
                this.biteTicks = 15;
            }
            if (this.m_20089_() == Pose.STANDING) {
                this.biteRightAnimationState.m_216973_();
                this.biteLeftAnimationState.m_216973_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        Majungasaurus majungasaurus = (Majungasaurus)((EntityType)UP2Entities.MAJUNGASAURUS.get()).m_20615_((Level)serverLevel);
        majungasaurus.setVariant(this.getVariant());
        return majungasaurus;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isMajungasaurusStealthMode() ? SoundEvents.f_271165_ : (SoundEvent)UP2SoundEvents.MAJUNGASAURUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)UP2SoundEvents.MAJUNGASAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.MAJUNGASAURUS_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.isMajungasaurusStealthMode()) {
            this.m_5496_(SoundEvents.f_244506_, 0.1f, 0.9f);
        } else {
            this.m_5496_(SoundEvents.f_244506_, 1.0f, 0.9f);
        }
    }

    @Override
    public int getVariantCount() {
        return MajungasaurusVariant.values().length;
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compoundTag) {
        if (level.m_213780_().m_188501_() < 0.15f && level.m_6018_().m_46462_()) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(level, difficulty, spawnType, spawnData, compoundTag);
    }

    public static enum MajungasaurusVariant {
        MAJUNGASAURUS(0),
        DUSKLURKER(1);

        private final int id;

        private MajungasaurusVariant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static MajungasaurusVariant byId(int id) {
            if (id < 0 || id >= MajungasaurusVariant.values().length) {
                id = 0;
            }
            return MajungasaurusVariant.values()[id];
        }
    }
}

