/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.ai.goals.carnotaurus;

import com.barlinc.unusual_prehistory.entity.Carnotaurus;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class CarnotaurusWaveGoal
extends Goal {
    private static final TargetingConditions FRIEND_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();
    protected final Carnotaurus carnotaurus;
    protected final Level level;
    @Nullable
    protected Carnotaurus friend;
    private int timer;

    public CarnotaurusWaveGoal(Carnotaurus carnotaurus) {
        this.carnotaurus = carnotaurus;
        this.level = carnotaurus.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.carnotaurus.waveCooldown > 0 && this.carnotaurus.m_20089_() != Pose.STANDING && this.carnotaurus.m_20069_()) {
            return false;
        }
        this.friend = this.getFriend();
        return this.friend != null;
    }

    public boolean m_8045_() {
        return this.friend != null && this.friend.m_6084_() && this.timer < 60;
    }

    public void m_8041_() {
        this.friend = null;
        this.timer = 0;
        this.carnotaurus.m_20124_(Pose.STANDING);
        this.carnotaurus.waveCooldown = this.carnotaurus.m_217043_().m_188503_(1600) + 800;
    }

    public void m_8037_() {
        if (this.friend != null) {
            this.carnotaurus.m_21563_().m_24960_((Entity)this.friend, 10.0f, (float)this.carnotaurus.m_8132_());
            if (this.carnotaurus.m_20280_((Entity)this.friend) > 26.0) {
                this.carnotaurus.m_21573_().m_5624_((Entity)this.friend, 1.0);
            }
            ++this.timer;
            if (this.carnotaurus.m_20280_((Entity)this.friend) < 25.0) {
                this.carnotaurus.m_21573_().m_26573_();
                this.friend.m_21573_().m_26573_();
                this.carnotaurus.m_20124_(UP2Poses.WAVING.get());
                this.friend.m_20124_(UP2Poses.WAVING.get());
            }
            if (this.timer > 70) {
                this.m_8041_();
                this.friend.m_20124_(Pose.STANDING);
                this.friend.waveCooldown = this.carnotaurus.m_217043_().m_188503_(1600) + 800;
            }
        }
    }

    @Nullable
    private Carnotaurus getFriend() {
        List list = this.level.m_45971_(Carnotaurus.class, FRIEND_TARGETING, (LivingEntity)this.carnotaurus, this.carnotaurus.m_20191_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        Carnotaurus carnotaurus = null;
        for (Carnotaurus carnotaurus1 : list) {
            if (!(this.carnotaurus.m_20280_((Entity)carnotaurus1) < d0)) continue;
            carnotaurus = carnotaurus1;
            d0 = this.carnotaurus.m_20280_((Entity)carnotaurus1);
        }
        return carnotaurus;
    }
}

