/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.registry;

import com.barlinc.unusual_prehistory.entity.projectile.ThrowableEgg;
import com.barlinc.unusual_prehistory.registry.UP2Blocks;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2Items;
import com.google.common.collect.ImmutableSet;
import java.util.function.Supplier;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;

public class UP2Compat {
    public static void registerCompat() {
        UP2Compat.registerCompostables();
        UP2Compat.registerFlammables();
        UP2Compat.registerDispenserBehaviours();
        UP2Compat.registerSigns();
        UP2Compat.registerHangingSigns();
    }

    public static void registerCompostables() {
        UP2Compat.registerCompostable((ItemLike)UP2Items.GINKGO_FRUIT.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.CALAMOPHYTON.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.CLADOPHLEBIS.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.COOKSONIA.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.HORSETAIL.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.LARGE_HORSETAIL.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.QUILLWORT.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.LEEFRUCTUS.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.RAIGUENRAYUN.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.RHYNIA.get(), 0.65f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.GINKGO_LEAVES.get(), 0.3f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.GOLDEN_GINKGO_LEAVES.get(), 0.3f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.GINKGO_SAPLING.get(), 0.3f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.GOLDEN_GINKGO_SAPLING.get(), 0.3f);
        UP2Compat.registerCompostable((ItemLike)UP2Blocks.LEPIDODENDRON_LEAVES.get(), 0.3f);
    }

    public static void registerFlammables() {
        UP2Compat.registerFlammable((Block)UP2Blocks.CALAMOPHYTON.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.CLADOPHLEBIS.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.COOKSONIA.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.HORSETAIL.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.LARGE_HORSETAIL.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.QUILLWORT.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEEFRUCTUS.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.RAIGUENRAYUN.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.RHYNIA.get(), 60, 100);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_LOG.get(), 5, 3);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_WOOD.get(), 5, 3);
        UP2Compat.registerFlammable((Block)UP2Blocks.STRIPPED_GINKGO_LOG.get(), 5, 3);
        UP2Compat.registerFlammable((Block)UP2Blocks.STRIPPED_GINKGO_WOOD.get(), 5, 3);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_PLANKS.get(), 5, 15);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_SLAB.get(), 5, 15);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_STAIRS.get(), 5, 15);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_FENCE.get(), 5, 15);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_FENCE_GATE.get(), 5, 15);
        UP2Compat.registerFlammable((Block)UP2Blocks.GINKGO_LEAVES.get(), 30, 50);
        UP2Compat.registerFlammable((Block)UP2Blocks.GOLDEN_GINKGO_LEAVES.get(), 30, 50);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_LOG.get(), 5, 5);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_WOOD.get(), 5, 5);
        UP2Compat.registerFlammable((Block)UP2Blocks.MOSSY_LEPIDODENDRON_LOG.get(), 5, 5);
        UP2Compat.registerFlammable((Block)UP2Blocks.MOSSY_LEPIDODENDRON_WOOD.get(), 5, 5);
        UP2Compat.registerFlammable((Block)UP2Blocks.STRIPPED_LEPIDODENDRON_LOG.get(), 5, 5);
        UP2Compat.registerFlammable((Block)UP2Blocks.STRIPPED_LEPIDODENDRON_WOOD.get(), 5, 5);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_PLANKS.get(), 5, 20);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_SLAB.get(), 5, 20);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_STAIRS.get(), 5, 20);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_FENCE.get(), 5, 20);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_FENCE_GATE.get(), 5, 20);
        UP2Compat.registerFlammable((Block)UP2Blocks.LEPIDODENDRON_LEAVES.get(), 30, 60);
    }

    public static void registerDispenserBehaviours() {
        UP2Compat.registerDinosaurEggDispenserBehaviour(UP2Items.DROMAEOSAURUS_EGG, () -> UP2Entities.DROMAEOSAURUS_EGG.get());
        UP2Compat.registerDinosaurEggDispenserBehaviour(UP2Items.TALPANAS_EGG, () -> UP2Entities.TALPANAS_EGG.get());
        UP2Compat.registerDinosaurEggDispenserBehaviour(UP2Items.TELECREX_EGG, () -> UP2Entities.TELECREX_EGG.get());
    }

    public static void registerDinosaurEggDispenserBehaviour(Supplier<Item> itemSupplier, final Supplier<EntityType<? extends ThrowableEgg>> entityTypeSupplier) {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)itemSupplier.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile m_6895_(@NotNull Level level, @NotNull Position pos, @NotNull ItemStack itemStack) {
                ThrowableEgg egg = (ThrowableEgg)((EntityType)entityTypeSupplier.get()).m_20615_(level);
                egg.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                return egg;
            }
        });
    }

    public static void registerSigns() {
        ImmutableSet.Builder signs = new ImmutableSet.Builder();
        signs.addAll((Iterable)BlockEntityType.f_58924_.f_58915_);
        signs.add((Object)((Block)UP2Blocks.GINKGO_SIGN.get()));
        signs.add((Object)((Block)UP2Blocks.GINKGO_WALL_SIGN.get()));
        signs.add((Object)((Block)UP2Blocks.LEPIDODENDRON_SIGN.get()));
        signs.add((Object)((Block)UP2Blocks.LEPIDODENDRON_WALL_SIGN.get()));
        BlockEntityType.f_58924_.f_58915_ = signs.build();
    }

    public static void registerHangingSigns() {
        ImmutableSet.Builder hangingSigns = new ImmutableSet.Builder();
        hangingSigns.addAll((Iterable)BlockEntityType.f_244529_.f_58915_);
        hangingSigns.add((Object)((Block)UP2Blocks.GINKGO_HANGING_SIGN.get()));
        hangingSigns.add((Object)((Block)UP2Blocks.GINKGO_WALL_HANGING_SIGN.get()));
        hangingSigns.add((Object)((Block)UP2Blocks.LEPIDODENDRON_HANGING_SIGN.get()));
        hangingSigns.add((Object)((Block)UP2Blocks.LEPIDODENDRON_WALL_HANGING_SIGN.get()));
        BlockEntityType.f_244529_.f_58915_ = hangingSigns.build();
    }

    public static void registerCompostable(ItemLike item, float chance) {
        ComposterBlock.f_51914_.put((Object)item.m_5456_(), chance);
    }

    public static void registerFlammable(Block block, int igniteChance, int burnChance) {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_(block, igniteChance, burnChance);
    }
}

