/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.client.renderer.layers;

import com.barlinc.unusual_prehistory.UnusualPrehistory2;
import com.barlinc.unusual_prehistory.client.models.entity.MegalaniaModel;
import com.barlinc.unusual_prehistory.entity.Megalania;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MegalaniaTemperatureLayer
extends RenderLayer<Megalania, MegalaniaModel> {
    private static final ResourceLocation TEXTURE = UnusualPrehistory2.modPrefix("textures/entity/megalania/megalania_temperate.png");
    private static final ResourceLocation TEXTURE_COLD = UnusualPrehistory2.modPrefix("textures/entity/megalania/megalania_cold.png");
    private static final ResourceLocation TEXTURE_WARM = UnusualPrehistory2.modPrefix("textures/entity/megalania/megalania_warm.png");
    private static final ResourceLocation TEXTURE_NETHER = UnusualPrehistory2.modPrefix("textures/entity/megalania/megalania_nether.png");

    public MegalaniaTemperatureLayer(RenderLayerParent<Megalania, MegalaniaModel> parent) {
        super(parent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, Megalania entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_20145_()) {
            float tempProgress = entity.prevTempProgress + (entity.tempProgress - entity.prevTempProgress) * partialTicks;
            float a = 1.0f;
            if (entity.getPrevTemperatureState() != null) {
                float alphaPrev = 1.0f - tempProgress * 0.2f;
                VertexConsumer prev = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTexture(entity.getPrevTemperatureState())));
                if (entity.getPrevTemperatureState() == entity.getTemperatureState()) {
                    alphaPrev *= a;
                }
                ((MegalaniaModel)this.m_117386_()).m_7695_(poseStack, prev, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, alphaPrev);
            }
            float alphaCurrent = tempProgress * 0.2f;
            VertexConsumer current = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTexture(entity.getTemperatureState())));
            ((MegalaniaModel)this.m_117386_()).m_7695_(poseStack, current, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, a * alphaCurrent);
        }
    }

    public ResourceLocation getTexture(Megalania.TemperatureStates state) {
        if (state == Megalania.TemperatureStates.COLD) {
            return TEXTURE_COLD;
        }
        if (state == Megalania.TemperatureStates.WARM) {
            return TEXTURE_WARM;
        }
        if (state == Megalania.TemperatureStates.NETHER) {
            return TEXTURE_NETHER;
        }
        if (state == Megalania.TemperatureStates.TEMPERATE) {
            return TEXTURE;
        }
        return TEXTURE;
    }
}

