/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.CustomizableRandomSwimGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.DiplocaulusBurrowInMudGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.LargePanicGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.SemiAquaticRandomStrollGoal;
import com.barlinc.unusual_prehistory.entity.ai.navigation.SmoothGroundPathNavigation;
import com.barlinc.unusual_prehistory.entity.base.SemiAquaticMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2Items;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Diplocaulus
extends SemiAquaticMob
implements Bucketable {
    public static final EntityDataAccessor<Integer> BURROW_COOLDOWN = SynchedEntityData.m_135353_(Diplocaulus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDimensions BURROWED_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)0.25f);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Diplocaulus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState swimIdleAnimationState = new AnimationState();
    public final AnimationState burrowStartAnimationState = new AnimationState();
    public final AnimationState burrowIdleAnimationState = new AnimationState();
    public final AnimationState quirkAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    private final byte QUIRK = (byte)66;

    public Diplocaulus(EntityType<? extends SemiAquaticMob> entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.18f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LargePanicGoal(this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new CustomizableRandomSwimGoal((PathfinderMob)this, 1.0, 80, 10, 10, 3));
        this.f_21345_.m_25352_(2, (Goal)new SemiAquaticRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.DIPLOCAULUS_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new DiplocaulusBurrowInMudGoal(this));
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new SmoothGroundPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new LookControl((Mob)this);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.1f, false);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
            this.isLandNavigator = false;
        }
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.refuseToMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            travelVector = travelVector.m_82542_(0.0, 1.0, 0.0);
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.f_19862_) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3 * (double)this.m_6113_(), 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.DIPLOCAULUS_FOOD);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return pose == UP2Poses.BURROWED.get() ? BURROWED_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    @Override
    public void m_8119_() {
        boolean ground;
        super.m_8119_();
        boolean bl = ground = !this.m_20069_();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isDiplocaulusBurrowed() && this.m_20072_()) {
            this.exitBurrow();
        }
    }

    @Override
    public void setupAnimationStates() {
        this.idleAnimationState.m_246184_(!this.m_20069_(), this.f_19797_);
        this.swimIdleAnimationState.m_246184_(this.m_20069_(), this.f_19797_);
        if (this.isDiplocaulusVisuallyBurrowed()) {
            this.quirkAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            if (this.isVisuallyBurrowed()) {
                this.burrowStartAnimationState.m_216982_(this.f_19797_);
                this.burrowIdleAnimationState.m_216973_();
            } else {
                this.burrowStartAnimationState.m_216973_();
                this.burrowIdleAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.burrowStartAnimationState.m_216973_();
            this.burrowIdleAnimationState.m_216973_();
        }
    }

    @Override
    public void setupAnimationCooldowns() {
        if (this.getBehavior().equals(Behaviors.IDLE.getName())) {
            if (this.getBurrowCooldown() > 0) {
                this.setBurrowCooldown(this.getBurrowCooldown() - 1);
            }
            if (this.f_19796_.m_188503_(650) == 0 && !this.quirkAnimationState.m_216984_()) {
                this.m_9236_().m_7605_((Entity)this, this.QUIRK);
            }
        }
    }

    @Override
    public void m_7822_(byte id) {
        if (id == this.QUIRK) {
            this.quirkAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public boolean refuseToMove() {
        return super.refuseToMove() || this.isDiplocaulusBurrowed();
    }

    protected void m_7880_(float distance) {
        if (distance > 4.0f && this.isDiplocaulusBurrowed() && !this.isInPoseTransition()) {
            this.exitBurrow();
        }
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float amount) {
        this.exitBurrow();
        super.m_6475_(damageSource, amount);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BURROW_COOLDOWN, (Object)(1600 + this.m_217043_().m_188503_(2400)));
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("BurrowCooldown", this.getBurrowCooldown());
        compoundTag.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setBurrowCooldown(compoundTag.m_128451_("BurrowCooldown"));
        this.m_27497_(compoundTag.m_128471_("FromBucket"));
    }

    public int getBurrowCooldown() {
        return (Integer)this.f_19804_.m_135370_(BURROW_COOLDOWN);
    }

    public void setBurrowCooldown(int cooldown) {
        this.f_19804_.m_135381_(BURROW_COOLDOWN, (Object)cooldown);
    }

    public void burrowCooldown() {
        this.f_19804_.m_135381_(BURROW_COOLDOWN, (Object)(1600 + this.f_19796_.m_188503_(2400)));
    }

    public void exitBurrowCooldown() {
        this.f_19804_.m_135381_(BURROW_COOLDOWN, (Object)(800 + this.f_19796_.m_188503_(2000)));
    }

    public boolean isDiplocaulusBurrowed() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isDiplocaulusVisuallyBurrowed() {
        return this.getPoseTime() < 0L != this.isDiplocaulusBurrowed();
    }

    @Override
    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < 40L;
    }

    private boolean isVisuallyBurrowed() {
        return this.isDiplocaulusBurrowed() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void burrow() {
        if (this.isDiplocaulusBurrowed()) {
            return;
        }
        this.m_20124_(UP2Poses.BURROWED.get());
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void exitBurrow() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)UP2SoundEvents.DIPLOCAULUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)UP2SoundEvents.DIPLOCAULUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.DIPLOCAULUS_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_(SoundEvents.f_215696_, 0.1f, 1.5f);
    }

    public float m_6121_() {
        return 0.7f;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        Diplocaulus entity = (Diplocaulus)((EntityType)UP2Entities.DIPLOCAULUS.get()).m_20615_((Level)level);
        entity.setVariant(this.getVariant());
        return entity;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void m_6872_(@NotNull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundTag = bucket.m_41784_();
        compoundTag.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@NotNull CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
        if (compoundTag.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compoundTag.m_128451_("BucketVariantTag"));
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)UP2Items.DIPLOCAULUS_BUCKET.get());
    }

    @Override
    public int getVariantCount() {
        return DiplocaulusVariant.values().length;
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(level, difficulty, spawnType, spawnGroupData, compoundTag);
        if (spawnType == MobSpawnType.BUCKET && compoundTag != null && compoundTag.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compoundTag.m_128451_("BucketVariantTag"));
        } else {
            this.setVariant(this.f_19796_.m_188503_(DiplocaulusVariant.values().length));
        }
        return spawnGroupData;
    }

    public static enum DiplocaulusVariant {
        BREVIROSTRIS(0),
        MAGNICORNIS(1),
        RECURVATIS(2),
        SALAMANDROIDES(3);

        private final int id;

        private DiplocaulusVariant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static DiplocaulusVariant byId(int id) {
            if (id < 0 || id >= DiplocaulusVariant.values().length) {
                id = 0;
            }
            return DiplocaulusVariant.values()[id];
        }
    }
}

