/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.LargeBabyPanicGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.kentrosaurus.KentrosaurusAttackGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.kentrosaurus.KentrosaurusDefendThornsGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.kentrosaurus.KentrosaurusFollowThornsGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.kentrosaurus.KentrosaurusLayDownGoal;
import com.barlinc.unusual_prehistory.entity.ai.navigation.PrehistoricMobMoveControl;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2DamageTypeTags;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Kentrosaurus
extends PrehistoricMob {
    public static final EntityDataAccessor<Integer> LAY_DOWN_COOLDOWN = SynchedEntityData.m_135353_(Kentrosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.m_20395_((float)1.98f, (float)1.75f);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attack1AnimationState = new AnimationState();
    public final AnimationState attack2AnimationState = new AnimationState();
    public final AnimationState standUpAnimationState = new AnimationState();
    public final AnimationState layDownAnimationState = new AnimationState();
    public final AnimationState layDownIdleAnimationState = new AnimationState();
    public final AnimationState grazeAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    private int attackTicks;
    private final byte GRAZE = (byte)66;
    private int grazingTicks = 0;

    public Kentrosaurus(EntityType<? extends PrehistoricMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new KentrosaurusMoveControl(this);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LargeBabyPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new KentrosaurusAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new KentrosaurusFollowThornsGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.KENTROSAURUS_FOOD), false));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new KentrosaurusLayDownGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new KentrosaurusDefendThornsGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, (double)0.16f);
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.9f;
    }

    @Override
    public double m_20204_() {
        if (this.useLowerFluidJumpThreshold) {
            return super.m_20204_();
        }
        return 0.35 * (double)this.m_20206_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.KENTROSAURUS_FOOD);
    }

    public boolean entityHasThorns(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD).getEnchantmentLevel(Enchantments.f_44972_) > 0 || entity.m_6844_(EquipmentSlot.CHEST).getEnchantmentLevel(Enchantments.f_44972_) > 0 || entity.m_6844_(EquipmentSlot.LEGS).getEnchantmentLevel(Enchantments.f_44972_) > 0 || entity.m_6844_(EquipmentSlot.FEET).getEnchantmentLevel(Enchantments.f_44972_) > 0;
    }

    public static void angerNearbyKentrosaurus(Player player, boolean angerIfSeen) {
        List list = player.m_9236_().m_45976_(Kentrosaurus.class, player.m_20191_().m_82400_(16.0));
        list.stream().filter(kentrosaurus -> !angerIfSeen || BehaviorUtils.m_22667_((LivingEntity)kentrosaurus, (LivingEntity)player)).forEach(kentrosaurus -> kentrosaurus.standAndSetTarget((LivingEntity)player));
    }

    private void standAndSetTarget(LivingEntity target) {
        this.m_6710_(target);
        this.standUp();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isKentrosaurusLayingDown() && this.m_20072_()) {
            this.standUpInstantly();
        }
        if (this.m_9236_().m_45527_(this.m_20183_()) && (this.m_9236_().m_46470_() || this.m_9236_().m_46471_())) {
            this.standUp();
        }
    }

    @Override
    public void setupAnimationCooldowns() {
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        if (this.attackTicks == 0 && this.m_20089_() == UP2Poses.TAIL_WHIPPING.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (!this.m_20072_() && this.getBehavior().equals(Behaviors.IDLE.getName())) {
            if (this.getLayDownCooldown() > 0) {
                this.setLayDownCooldown(this.getLayDownCooldown() - 1);
            }
            if (this.canGraze() && this.f_19796_.m_188503_(350) == 0) {
                this.setGrazing(true);
            }
            if (this.isGrazing() && this.grazingTicks++ > 40) {
                this.grazingTicks = 0;
                this.setGrazing(false);
            }
        }
    }

    private boolean canGraze() {
        return !this.isKentrosaurusLayingDown() && this.m_20089_() == Pose.STANDING && !this.isGrazing() && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_);
    }

    @Override
    public void setupAnimationStates() {
        if (this.attackTicks == 0 && (this.attack1AnimationState.m_216984_() || this.attack2AnimationState.m_216984_())) {
            this.attack1AnimationState.m_216973_();
            this.attack2AnimationState.m_216973_();
        }
        this.idleAnimationState.m_246184_(!this.m_20069_() && this.m_20089_() != UP2Poses.TAIL_WHIPPING.get(), this.f_19797_);
        this.swimmingAnimationState.m_246184_(this.m_20069_() && this.m_20089_() != UP2Poses.TAIL_WHIPPING.get(), this.f_19797_);
        this.grazeAnimationState.m_246184_(this.isGrazing(), this.f_19797_);
        if (this.isKentrosaurusVisuallyLayingDown()) {
            this.standUpAnimationState.m_216973_();
            this.attack1AnimationState.m_216973_();
            this.attack2AnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            this.grazeAnimationState.m_216973_();
            if (this.isVisuallyLayingDown()) {
                this.layDownAnimationState.m_216982_(this.f_19797_);
                this.layDownIdleAnimationState.m_216973_();
            } else {
                this.layDownAnimationState.m_216973_();
                this.layDownIdleAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.layDownAnimationState.m_216973_();
            this.layDownIdleAnimationState.m_216973_();
            this.standUpAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        if (f_19806_.equals(accessor)) {
            if (this.m_20089_() == UP2Poses.TAIL_WHIPPING.get()) {
                this.grazeAnimationState.m_216973_();
                if (this.m_217043_().m_188499_()) {
                    this.attack1AnimationState.m_216977_(this.f_19797_);
                } else {
                    this.attack2AnimationState.m_216977_(this.f_19797_);
                }
                this.attackTicks = 40;
            } else {
                this.attack1AnimationState.m_216973_();
                this.attack2AnimationState.m_216973_();
            }
        }
        super.m_7350_(accessor);
    }

    public boolean isGrazing() {
        return this.getFlag(66);
    }

    public void setGrazing(boolean grazing) {
        this.setFlag(66, grazing);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return pose == UP2Poses.RESTING.get() ? SITTING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public boolean m_5829_() {
        return this.isKentrosaurusLayingDown();
    }

    public void m_7023_(@NotNull Vec3 vec3) {
        if (this.refuseToMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    protected void m_7880_(float distance) {
        if (distance > 6.0f && this.isKentrosaurusLayingDown() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    protected void m_6475_(DamageSource damageSource, float amount) {
        this.standUpInstantly();
        if (!damageSource.m_269533_(DamageTypeTags.f_268640_) && !damageSource.m_276093_(DamageTypes.f_268440_)) {
            Entity entity = damageSource.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                target.m_6469_(this.m_269291_().m_269374_((Entity)this), 2.0f);
            }
            super.m_6475_(damageSource, amount);
        }
        super.m_6475_(damageSource, amount);
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return super.m_6673_(source) || source.m_269533_(UP2DamageTypeTags.KENTROSAURUS_IMMUNE_TO);
    }

    @Override
    public boolean refuseToMove() {
        return super.refuseToMove() || this.isKentrosaurusLayingDown() || this.isGrazing() && this.grazingTicks > 0;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAY_DOWN_COOLDOWN, (Object)(2500 + this.m_217043_().m_188503_(2400)));
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("LayDownCooldown", this.getLayDownCooldown());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setLayDownCooldown(compoundTag.m_128451_("LayDownCooldown"));
    }

    public int getLayDownCooldown() {
        return (Integer)this.f_19804_.m_135370_(LAY_DOWN_COOLDOWN);
    }

    public void setLayDownCooldown(int cooldown) {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)cooldown);
    }

    public void layDownCooldown() {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)(2500 + this.f_19796_.m_188503_(2400)));
    }

    public void standUpCooldown() {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)(800 + this.f_19796_.m_188503_(2000)));
    }

    public boolean isKentrosaurusLayingDown() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isKentrosaurusVisuallyLayingDown() {
        return this.getPoseTime() < 0L != this.isKentrosaurusLayingDown();
    }

    @Override
    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < 20L;
    }

    private boolean isVisuallyLayingDown() {
        return this.isKentrosaurusLayingDown() && this.getPoseTime() < 20L && this.getPoseTime() >= 0L;
    }

    public void layDown() {
        if (this.isKentrosaurusLayingDown()) {
            return;
        }
        this.m_20124_(UP2Poses.RESTING.get());
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void standUp() {
        if (!this.isKentrosaurusLayingDown()) {
            return;
        }
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void standUpInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)UP2Entities.KENTROSAURUS.get()).m_20615_((Level)level);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)UP2SoundEvents.KENTROSAURUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)UP2SoundEvents.KENTROSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.KENTROSAURUS_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_((SoundEvent)UP2SoundEvents.KENTROSAURUS_STEP.get(), 1.0f, 1.1f);
    }

    public int m_8100_() {
        return 160;
    }

    private static class KentrosaurusMoveControl
    extends PrehistoricMobMoveControl {
        protected final Kentrosaurus kentrosaurus;

        public KentrosaurusMoveControl(Kentrosaurus kentrosaurus) {
            super(kentrosaurus);
            this.kentrosaurus = kentrosaurus;
        }

        @Override
        public void m_8126_() {
            if (!this.kentrosaurus.refuseToMove()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.kentrosaurus.m_21523_() && this.kentrosaurus.isKentrosaurusLayingDown() && !this.kentrosaurus.isInPoseTransition()) {
                    this.kentrosaurus.standUp();
                }
                super.m_8126_();
            }
        }
    }
}

