/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.GroundseekingRandomSwimGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.LargeBabyPanicGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.OnchopristisAttackGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.PrehistoricNearestAttackableTargetGoal;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricAquaticMob;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2EntityTags;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Onchopristis
extends PrehistoricAquaticMob {
    public static final EntityDataAccessor<Integer> BURROW_COOLDOWN = SynchedEntityData.m_135353_(Onchopristis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDimensions BURROWED_DIMENSIONS = EntityDimensions.m_20395_((float)1.2f, (float)0.34f);
    public final AnimationState attack1AnimationState = new AnimationState();
    public final AnimationState attack2AnimationState = new AnimationState();
    public final AnimationState steppedOnAnimationState = new AnimationState();
    public final AnimationState burrowStartAnimationState = new AnimationState();
    public final AnimationState burrowAnimationState = new AnimationState();
    public final AnimationState burrowEndAnimationState = new AnimationState();
    private int attackTicks;
    private int stepTicks;
    private final byte STEP = (byte)60;

    public Onchopristis(EntityType<? extends PrehistoricMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new OnchopristisMoveControl(this);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.64f).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new LargeBabyPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.ONCHOPRISTIS_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new OnchopristisAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new GroundseekingRandomSwimGoal((PathfinderMob)this, 1.0, 60, 12, 12, 0.02));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, new PrehistoricNearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 300, true, true, entity -> entity.m_6095_().m_204039_(UP2EntityTags.ONCHOPRISTIS_TARGETS)));
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.refuseToMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            travelVector = travelVector.m_82542_(0.0, 1.0, 0.0);
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.f_19862_) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3 * (double)this.m_6113_(), 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.stepTicks > 0) {
            --this.stepTicks;
        }
        if (this.m_6084_() && this.isOnchopristisBurrowed() && !this.m_9236_().f_46443_ && this.m_5448_() == null && this.stepTicks == 0) {
            this.getSteppedOn();
        }
        if (this.m_20069_() && this.getBehavior().equals(Behaviors.IDLE.getName()) && this.getBurrowCooldown() > 0) {
            this.setBurrowCooldown(this.getBurrowCooldown() - 1);
        }
        this.tickBurrowing();
    }

    private void tickBurrowing() {
        if (this.isOnchopristisBurrowed() && !this.m_20069_()) {
            this.exitBurrowInstantly();
        }
        if (this.m_20069_()) {
            if (!this.m_21523_() && this.getBurrowCooldown() == 0 && this.m_20096_() && !this.isOnchopristisBurrowed() && this.getBehavior().equals(Behaviors.IDLE.getName())) {
                this.burrow();
            }
            if (!(this.m_20096_() && !this.isOnchopristisBurrowed() || this.getBurrowCooldown() != 0 || this.m_21523_())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
            }
        }
        if (this.isOnchopristisBurrowed() && this.m_217043_().m_188503_(2200) == 0) {
            this.burrowCooldown();
            this.exitBurrow();
        }
    }

    private void getSteppedOn() {
        this.m_9236_().m_45933_((Entity)this, this.getAggroHitbox()).forEach(entity -> {
            LivingEntity mob;
            if (entity instanceof LivingEntity && (mob = (LivingEntity)entity).m_6084_() && !(mob instanceof Onchopristis)) {
                if (EntitySelector.f_20406_.test(mob)) {
                    this.m_6710_(mob);
                    this.exitBurrowInstantly();
                    this.burrowCooldown();
                }
                this.m_9236_().m_7605_((Entity)this, this.STEP);
                this.stepTicks = 5;
            }
        });
    }

    @NotNull
    private AABB getAggroHitbox() {
        return this.m_20191_().m_82377_(0.25, 0.0, 0.25).m_82386_(0.0, 0.36, 0.0);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return pose == UP2Poses.BURROWED.get() ? BURROWED_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public boolean m_5829_() {
        return this.isOnchopristisBurrowed();
    }

    protected void m_7880_(float distance) {
        if (distance > 6.0f && this.isOnchopristisBurrowed() && !this.isInPoseTransition()) {
            this.exitBurrow();
        }
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float amount) {
        this.exitBurrowInstantly();
        super.m_6475_(damageSource, amount);
    }

    public void burrowCooldown() {
        this.f_19804_.m_135381_(BURROW_COOLDOWN, (Object)(300 + this.f_19796_.m_188503_(3600)));
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.attackTicks == 0 && (this.attack1AnimationState.m_216984_() || this.attack2AnimationState.m_216984_())) {
            this.attack1AnimationState.m_216973_();
            this.attack2AnimationState.m_216973_();
        }
        if (this.isOnchopristisVisuallyBurrowed()) {
            this.burrowEndAnimationState.m_216973_();
            this.attack1AnimationState.m_216973_();
            this.attack2AnimationState.m_216973_();
            this.swimIdleAnimationState.m_216973_();
            if (this.isVisuallyBurrowed()) {
                this.burrowStartAnimationState.m_216982_(this.f_19797_);
                this.burrowAnimationState.m_216973_();
            } else {
                this.burrowStartAnimationState.m_216973_();
                this.burrowAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.burrowStartAnimationState.m_216973_();
            this.burrowAnimationState.m_216973_();
            this.burrowEndAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    @Override
    public void setupAnimationCooldowns() {
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        if (this.attackTicks == 0 && this.m_20089_() == UP2Poses.ATTACKING.get()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        if (f_19806_.equals(accessor)) {
            if (this.m_20089_() == UP2Poses.ATTACKING.get()) {
                if (this.m_217043_().m_188499_()) {
                    this.attack1AnimationState.m_216977_(this.f_19797_);
                } else {
                    this.attack2AnimationState.m_216977_(this.f_19797_);
                }
                this.attackTicks = 20;
            } else {
                this.attack1AnimationState.m_216973_();
                this.attack2AnimationState.m_216973_();
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    public void m_7822_(byte id) {
        if (id == this.STEP) {
            this.steppedOnAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public boolean refuseToMove() {
        return super.refuseToMove() || this.isOnchopristisBurrowed();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BURROW_COOLDOWN, (Object)(2500 + this.m_217043_().m_188503_(2400)));
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("BurrowCooldown", this.getBurrowCooldown());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setBurrowCooldown(compoundTag.m_128451_("BurrowCooldown"));
    }

    public int getBurrowCooldown() {
        return (Integer)this.f_19804_.m_135370_(BURROW_COOLDOWN);
    }

    public void setBurrowCooldown(int cooldown) {
        this.f_19804_.m_135381_(BURROW_COOLDOWN, (Object)cooldown);
    }

    public boolean isOnchopristisBurrowed() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isOnchopristisVisuallyBurrowed() {
        return this.getPoseTime() < 0L != this.isOnchopristisBurrowed();
    }

    @Override
    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < 20L;
    }

    private boolean isVisuallyBurrowed() {
        return this.isOnchopristisBurrowed() && this.getPoseTime() < 20L && this.getPoseTime() >= 0L;
    }

    public void burrow() {
        if (this.isOnchopristisBurrowed()) {
            return;
        }
        this.m_20124_(UP2Poses.BURROWED.get());
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void exitBurrow() {
        if (!this.isOnchopristisBurrowed()) {
            return;
        }
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void exitBurrowInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    @Override
    public boolean canPacifiy() {
        return true;
    }

    @Override
    public boolean isPacifyItem(ItemStack itemStack) {
        return itemStack.m_204117_(UP2ItemTags.PACIFIES_ONCHOPRISTIS);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.ONCHOPRISTIS_FOOD);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)UP2Entities.ONCHOPRISTIS.get()).m_20615_((Level)level);
    }

    @NotNull
    public ItemStack m_28282_() {
        return ItemStack.f_41583_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.ONCHOPRISTIS_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)UP2SoundEvents.ONCHOPRISTIS_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getFlopSound() {
        return (SoundEvent)UP2SoundEvents.ONCHOPRISTIS_FLOP.get();
    }

    private static class OnchopristisMoveControl
    extends SmoothSwimmingMoveControl {
        protected final Onchopristis onchopristis;

        public OnchopristisMoveControl(Onchopristis onchopristis) {
            super((Mob)onchopristis, 85, 10, 0.02f, 0.1f, false);
            this.onchopristis = onchopristis;
        }

        public void m_8126_() {
            if (!this.onchopristis.refuseToMove()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.onchopristis.m_21523_() && this.onchopristis.isOnchopristisBurrowed() && !this.onchopristis.isInPoseTransition()) {
                    this.onchopristis.exitBurrow();
                }
                super.m_8126_();
            }
        }
    }
}

