/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.ai.navigation;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;

public class AdvancedSwimNodeEvaluator
extends NodeEvaluator {
    private boolean allowBreaching;
    private boolean preferCrevices;
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public AdvancedSwimNodeEvaluator(boolean pAllowBreaching, boolean pPreferCrevices) {
        this.allowBreaching = pAllowBreaching;
        this.preferCrevices = pPreferCrevices;
    }

    public void m_6028_(PathNavigationRegion pLevel, Mob pMob) {
        super.m_6028_(pLevel, pMob);
        this.pathTypesByPosCache.clear();
    }

    public void m_6802_() {
        super.m_6802_();
        this.pathTypesByPosCache.clear();
    }

    public Node m_7171_() {
        return this.m_5676_(Mth.m_14107_((double)this.f_77313_.m_20191_().f_82288_), Mth.m_14107_((double)(this.f_77313_.m_20191_().f_82289_ + 0.5)), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82290_));
    }

    public Target m_7568_(double pX, double pY, double pZ) {
        return this.m_230615_(this.m_5676_(Mth.m_14107_((double)pX), Mth.m_14107_((double)pY), Mth.m_14107_((double)pZ)));
    }

    public int m_6065_(Node[] pOutputArray, Node pNode) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            Node node = this.findAcceptedNode(pNode.f_77271_ + direction.m_122429_(), pNode.f_77272_ + direction.m_122430_(), pNode.f_77273_ + direction.m_122431_());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            pOutputArray[i++] = node;
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            Direction direction2 = direction1.m_122427_();
            Node node1 = this.findAcceptedNode(pNode.f_77271_ + direction1.m_122429_() + direction2.m_122429_(), pNode.f_77272_, pNode.f_77273_ + direction1.m_122431_() + direction2.m_122431_());
            if (!this.isDiagonalNodeValid(node1, (Node)map.get(direction1), (Node)map.get(direction2))) continue;
            pOutputArray[i++] = node1;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable Node pNode) {
        return pNode != null && !pNode.f_77279_;
    }

    protected boolean isDiagonalNodeValid(@Nullable Node pRoot, @Nullable Node pHorizontal, @Nullable Node pClockwise) {
        return this.isNodeValid(pRoot) && pHorizontal != null && pHorizontal.f_77281_ >= 0.0f && pClockwise != null && pClockwise.f_77281_ >= 0.0f;
    }

    @Nullable
    protected Node findAcceptedNode(int pX, int pY, int pZ) {
        float f;
        Node node = null;
        BlockPathTypes blockpathtypes = this.getCachedBlockType(pX, pY, pZ);
        if ((this.allowBreaching && blockpathtypes == BlockPathTypes.BREACH || blockpathtypes == BlockPathTypes.WATER) && (f = this.f_77313_.m_21439_(blockpathtypes)) >= 0.0f) {
            node = this.m_5676_(pX, pY, pZ);
            node.f_77282_ = blockpathtypes;
            node.f_77281_ = Math.max(node.f_77281_, f);
            if (this.preferCrevices) {
                node.f_77281_ += this.countOpenSides(pX, pY, pZ);
            }
            if (this.f_77312_.m_6425_(new BlockPos(pX, pY, pZ)).m_76178_()) {
                node.f_77281_ += 8.0f;
            }
        }
        return node;
    }

    protected BlockPathTypes getCachedBlockType(int pX, int pY, int pZ) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)pX, (int)pY, (int)pZ), p_192957_ -> this.m_8086_((BlockGetter)this.f_77312_, pX, pY, pZ));
    }

    public BlockPathTypes m_8086_(BlockGetter pLevel, int pX, int pY, int pZ) {
        return this.m_7209_(pLevel, pX, pY, pZ, this.f_77313_);
    }

    public BlockPathTypes m_7209_(BlockGetter pLevel, int pX, int pY, int pZ, Mob pMob) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = pX; i < pX + this.f_77315_; ++i) {
            for (int j = pY; j < pY + this.f_77316_; ++j) {
                for (int k = pZ; k < pZ + this.f_77317_; ++k) {
                    FluidState fluidstate = pLevel.m_6425_((BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k));
                    BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k));
                    if (fluidstate.m_76178_() && blockstate.m_60647_(pLevel, blockpos$mutableblockpos.m_7495_(), PathComputationType.WATER) && blockstate.m_60795_()) {
                        return BlockPathTypes.BREACH;
                    }
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.BLOCKED;
                }
            }
        }
        BlockState blockstate1 = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
        return blockstate1.m_60647_(pLevel, (BlockPos)blockpos$mutableblockpos, PathComputationType.WATER) ? BlockPathTypes.WATER : BlockPathTypes.BLOCKED;
    }

    public float countOpenSides(int x, int y, int z) {
        BlockPos nodepos = new BlockPos(x, y, z);
        float end = 2.0f;
        if (!this.f_77312_.m_8055_(nodepos.m_7494_()).m_280296_()) {
            end *= end;
        }
        if (!this.f_77312_.m_8055_(nodepos.m_7495_()).m_280296_()) {
            end *= end;
        }
        if (!this.f_77312_.m_8055_(nodepos.m_122029_()).m_280296_()) {
            end *= end;
        }
        if (!this.f_77312_.m_8055_(nodepos.m_122024_()).m_280296_()) {
            end *= end;
        }
        if (!this.f_77312_.m_8055_(nodepos.m_122012_()).m_280296_()) {
            end *= end;
        }
        if (!this.f_77312_.m_8055_(nodepos.m_122019_()).m_280296_()) {
            end *= end;
        }
        return end - 2.0f;
    }

    public void setAllowBreaching(boolean pAllow) {
        this.allowBreaching = pAllow;
    }

    public void setPreferCrevices(boolean pAllow) {
        this.preferCrevices = pAllow;
    }
}

