/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.base;

import com.barlinc.unusual_prehistory.entity.ai.navigation.AdvancedWaterboundPathNavigation;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class PrehistoricAquaticMob
extends PrehistoricMob
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(PrehistoricAquaticMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float prevOnLandProgress;
    public float onLandProgress;
    public float rollAngle = 0.0f;
    public final AnimationState swimIdleAnimationState = new AnimationState();
    public final AnimationState floppingAnimationState = new AnimationState();

    protected PrehistoricAquaticMob(EntityType<? extends PrehistoricMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new AdvancedWaterboundPathNavigation((Mob)this, level);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevOnLandProgress = this.onLandProgress;
        this.tickFlopping();
        if (this.m_20069_()) {
            Vec3 movement = this.m_20184_();
            float speed = (float)movement.m_82553_();
            if (speed > 0.01f) {
                float targetRoll = (float)Math.toDegrees(Math.atan2(movement.f_82479_, movement.f_82481_)) * 0.1f;
                this.rollAngle += (targetRoll - this.rollAngle) * 0.05f;
            } else {
                this.rollAngle *= 0.9f;
            }
        }
    }

    @Override
    public void setupAnimationStates() {
        this.swimIdleAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
        this.floppingAnimationState.m_246184_(!this.m_20072_(), this.f_19797_);
    }

    public float flopChance() {
        return 0.3f;
    }

    public void tickFlopping() {
        if (!this.m_20072_() && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (this.m_20072_() && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        if (!this.m_20072_() && this.m_6084_() && this.m_20096_() && this.m_217043_().m_188501_() < this.flopChance()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.m_217043_().m_188501_() * 2.0f - 1.0f) * 0.1f), 0.3, (double)((this.m_217043_().m_188501_() * 2.0f - 1.0f) * 0.1f)));
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
    }

    public void m_6075_() {
        int airSupply = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(airSupply);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_27497_(compoundTag.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void m_6872_(@NotNull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundTag = bucket.m_41784_();
        compoundTag.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@NotNull CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
        if (compoundTag.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compoundTag.m_128451_("BucketVariantTag"));
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.canBucket()) {
            return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
        }
        return super.m_6071_(player, hand);
    }

    public boolean canBucket() {
        return false;
    }

    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public static boolean canSpawn(EntityType<? extends PrehistoricAquaticMob> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        int seaLevel = level.m_5736_();
        int minHeight = seaLevel - 13;
        return pos.m_123342_() >= minHeight && pos.m_123342_() <= seaLevel && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }
}

