/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.base;

import com.barlinc.unusual_prehistory.entity.ai.navigation.PrehistoricMobMoveControl;
import com.barlinc.unusual_prehistory.entity.ai.navigation.RefuseToMoveBodyRotationControl;
import com.barlinc.unusual_prehistory.entity.ai.navigation.RefuseToMoveLookControl;
import com.barlinc.unusual_prehistory.entity.ai.navigation.SmoothGroundPathNavigation;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.registry.UP2Criterion;
import com.barlinc.unusual_prehistory.registry.UP2Particles;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class PrehistoricMob
extends Animal {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(PrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> BEHAVIOR = SynchedEntityData.m_135353_(PrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.m_135353_(PrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public static final EntityDataAccessor<Byte> DATA_FLAGS = SynchedEntityData.m_135353_(PrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(PrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PACIFIED = SynchedEntityData.m_135353_(PrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IDLE_PLAYING = SynchedEntityData.m_135353_(PrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean useLowerFluidJumpThreshold = false;
    private int eepyTicks;
    private final byte PACIFY = (byte)9;

    protected PrehistoricMob(EntityType<? extends PrehistoricMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new PrehistoricMobMoveControl(this);
        this.f_21365_ = new RefuseToMoveLookControl(this);
        this.m_21530_();
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new RefuseToMoveBodyRotationControl(this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new SmoothGroundPathNavigation((Mob)this, level);
    }

    public float m_5610_(@NotNull BlockPos pos, @NotNull LevelReader level) {
        return 0.0f;
    }

    public double m_20204_() {
        if (this.useLowerFluidJumpThreshold) {
            return super.m_20204_();
        }
        return 0.6 * (double)this.m_20206_();
    }

    private void setUseLowerFluidJumpThreshold(boolean jumpThreshold) {
        this.useLowerFluidJumpThreshold = jumpThreshold;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_20069_() && this.f_19862_) {
            this.setUseLowerFluidJumpThreshold(true);
        }
    }

    public int m_213860_() {
        return 0;
    }

    public boolean m_5957_() {
        return false;
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.f_11912_;
    }

    public boolean isPacifyItem(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42437_);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_6898_(itemstack)) {
            int i = this.m_146764_();
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_146740_(PrehistoricMob.m_216967_((int)(-i)), true);
                this.m_5496_(this.getEatingSound(), 1.0f, this.m_6100_());
                this.applyFoodEffects(itemstack, this.m_9236_(), (LivingEntity)this);
                this.m_146850_(GameEvent.f_157806_);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        } else if (this.isPacifyItem(itemstack) && this.canPacifiy() && !this.isPacified() && !this.m_6162_()) {
            this.m_142075_(player, hand, itemstack);
            this.setPacified(true);
            this.m_5496_(this.getEatingSound(), 1.0f, this.m_6100_());
            this.applyFoodEffects(itemstack, this.m_9236_(), (LivingEntity)this);
            this.m_146850_(GameEvent.f_157806_);
            this.m_9236_().m_7605_((Entity)this, (byte)9);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                UP2Criterion.PACIFY_MOB.trigger(serverPlayer);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void strongKnockback(Entity entity, double horizontalStrength, double verticalStrength) {
        double x = entity.m_20185_() - this.m_20185_();
        double y = entity.m_20189_() - this.m_20189_();
        double scale = Math.max(x * x + y * y, 0.001);
        entity.m_5997_(x / scale * horizontalStrength, verticalStrength, y / scale * horizontalStrength);
    }

    private void applyFoodEffects(ItemStack food, Level level, LivingEntity livingEntity) {
        Item item = food.m_41720_();
        if (item.m_41472_()) {
            for (Pair pair : food.getFoodProperties((LivingEntity)this).m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
    }

    protected void spawnPacifyParticles() {
        ParticleOptions particleoptions = (ParticleOptions)UP2Particles.GOLDEN_HEART.get();
        for (int i = 0; i < 7; ++i) {
            double xspeed = this.f_19796_.m_188583_() * 0.02;
            double yspeed = this.f_19796_.m_188583_() * 0.08;
            double zspeed = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), xspeed, yspeed, zspeed);
        }
    }

    public void m_7822_(byte id) {
        if (id == 9) {
            this.spawnPacifyParticles();
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        this.setupAnimationCooldowns();
        if (this.f_19797_ % this.getHealCooldown() == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
        if (this.m_9236_().f_46443_ && this.shouldDoEepyParticles()) {
            this.doEepyParticles(1.7f);
        }
        if (this.m_21523_()) {
            this.m_183634_();
        }
    }

    public void setupAnimationCooldowns() {
    }

    public void setupAnimationStates() {
    }

    public void m_267651_(boolean flying) {
        float pos = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float speed = Math.min(pos * this.getWalkAnimationSpeed(), 1.0f);
        this.f_267362_.m_267566_(speed, 0.4f);
    }

    public float getWalkAnimationSpeed() {
        return this.m_6162_() ? 5.0f : 10.0f;
    }

    public int getHealCooldown() {
        return 250;
    }

    public void doEepyParticles(float particleOffset) {
        Vec3 lookVec = new Vec3(0.0, 0.0, (double)(-this.m_20205_() * particleOffset)).m_82524_((float)Math.toRadians(180.0f - this.m_6080_()));
        Vec3 eyeVec = this.m_146892_().m_82549_(lookVec);
        if (this.eepyTicks == 0) {
            this.eepyTicks = 40 + this.f_19796_.m_188503_(20);
            this.m_9236_().m_7106_((ParticleOptions)UP2Particles.EEPY.get(), eyeVec.f_82479_, eyeVec.f_82480_ + (double)((1.0f - this.f_19796_.m_188501_()) * 0.3f), eyeVec.f_82481_, 1.0, 0.0, 0.0);
        }
        if (this.eepyTicks > 0) {
            --this.eepyTicks;
        }
    }

    public boolean shouldDoEepyParticles() {
        return false;
    }

    public boolean isInPoseTransition() {
        return false;
    }

    public long getPoseTime() {
        return this.m_9236_().m_46467_() - Math.abs((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK));
    }

    public boolean refuseToMove() {
        return this.isInPoseTransition();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(BEHAVIOR, (Object)Behaviors.IDLE.getName());
        this.f_19804_.m_135372_(LAST_POSE_CHANGE_TICK, (Object)0L);
        this.f_19804_.m_135372_(DATA_FLAGS, (Object)0);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(PACIFIED, (Object)false);
        this.f_19804_.m_135372_(IDLE_PLAYING, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant());
        compoundTag.m_128356_("LastPoseTick", ((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK)).longValue());
        compoundTag.m_128379_("Pacified", this.isPacified());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(compoundTag.m_128451_("Variant"));
        long lastPoseTick = compoundTag.m_128454_("LastPoseTick");
        this.resetLastPoseChangeTick(lastPoseTick);
        this.setPacified(compoundTag.m_128471_("Pacified"));
    }

    protected boolean getFlag(int flagId) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS) & flagId) != 0;
    }

    protected void setFlag(int flagId, boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)(b0 | flagId)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)(b0 & ~flagId)));
        }
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int attackState) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)attackState);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)Mth.m_14045_((int)variant, (int)0, (int)this.getVariantCount()));
    }

    public int getVariantCount() {
        return 128;
    }

    public String getBehavior() {
        return (String)this.f_19804_.m_135370_(BEHAVIOR);
    }

    public void setBehavior(String behavior) {
        this.f_19804_.m_135381_(BEHAVIOR, (Object)behavior);
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long l) {
        this.f_19804_.m_135381_(LAST_POSE_CHANGE_TICK, (Object)l);
    }

    public void resetLastPoseChangeTickToFullStand(long l) {
        this.resetLastPoseChangeTick(Math.max(0L, l - 52L - 1L));
    }

    public boolean isPacified() {
        return (Boolean)this.f_19804_.m_135370_(PACIFIED);
    }

    public void setPacified(boolean pacified) {
        this.f_19804_.m_135381_(PACIFIED, (Object)pacified);
    }

    public boolean canPacifiy() {
        return false;
    }

    public boolean isIdlePlaying() {
        return (Boolean)this.f_19804_.m_135370_(IDLE_PLAYING);
    }

    public void setIdlePlaying(boolean idlePlaying) {
        this.f_19804_.m_135381_(IDLE_PLAYING, (Object)idlePlaying);
    }
}

