/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.client.renderer;

import com.barlinc.unusual_prehistory.UnusualPrehistory2;
import com.barlinc.unusual_prehistory.client.models.entity.MajungasaurusModel;
import com.barlinc.unusual_prehistory.entity.Majungasaurus;
import com.barlinc.unusual_prehistory.registry.UP2ModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class MajungasaurusRenderer
extends MobRenderer<Majungasaurus, MajungasaurusModel> {
    public MajungasaurusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MajungasaurusModel(context.m_174023_(UP2ModelLayers.MAJUNGASAURUS)), 0.8f);
    }

    public void render(Majungasaurus entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = entity.isMajungasaurusStealthMode() ? 0.0f : 0.8f;
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(Majungasaurus entity) {
        Majungasaurus.MajungasaurusVariant variant = Majungasaurus.MajungasaurusVariant.byId(entity.getVariant());
        return UnusualPrehistory2.modPrefix("textures/entity/majungasaurus/" + variant.name().toLowerCase(Locale.ROOT) + ".png");
    }

    @Nullable
    protected RenderType getRenderType(Majungasaurus entity, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (entity.getStealthProgress(1.0f) > 0.0f) {
            return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity));
        }
        return RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity));
    }

    protected void scale(Majungasaurus entity, @NotNull PoseStack poseStack, float partialTicks) {
        float alpha = 1.0f - 0.9f * entity.getStealthProgress(partialTicks);
        ((MajungasaurusModel)this.f_115290_).setAlpha(alpha);
    }
}

