/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.LargeBabyPanicGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.PrehistoricNearestAttackableTargetGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.carnotaurus.CarnotaurusAttackGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.carnotaurus.CarnotaurusChargeGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.carnotaurus.CarnotaurusRoarGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.carnotaurus.CarnotaurusSniffingGoal;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Carnotaurus
extends PrehistoricMob {
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(Carnotaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CHARGE_COOLDOWN = SynchedEntityData.m_135353_(Carnotaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ROARING = SynchedEntityData.m_135353_(Carnotaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> ROAR_COOLDOWN = SynchedEntityData.m_135353_(Carnotaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(Carnotaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState bite1AnimationState = new AnimationState();
    public final AnimationState bite2AnimationState = new AnimationState();
    public final AnimationState chargeAnimationState = new AnimationState();
    public final AnimationState headbuttAnimationState = new AnimationState();
    public final AnimationState sniffAnimationState = new AnimationState();
    public final AnimationState waveAnimationState = new AnimationState();
    public final AnimationState angryAnimationState = new AnimationState();
    public final AnimationState roarAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    public int sniffCooldown = this.f_19796_.m_188503_(600) + 600;
    public int waveCooldown = this.f_19796_.m_188503_(1600) + 1600;
    private int biteTicks;
    private int headbuttTicks;

    public Carnotaurus(EntityType<? extends PrehistoricMob> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CarnotaurusRoarGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CarnotaurusChargeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CarnotaurusAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LargeBabyPanicGoal(this, 1.7));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.CARNOTAURUS_FOOD), false));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new CarnotaurusSniffingGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, new PrehistoricNearestAttackableTargetGoal<Player>((PrehistoricMob)this, Player.class, true, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, (double)0.18f).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void roar() {
        if (this.m_6084_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)39);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 300, 2));
            this.m_146850_(GameEvent.f_223709_);
        }
    }

    public boolean isWithinYRange(LivingEntity target) {
        if (target == null) {
            return false;
        }
        return Math.abs(target.m_20186_() - this.m_20186_()) < 3.0;
    }

    @Override
    public boolean canPacifiy() {
        return true;
    }

    @Override
    public boolean isPacifyItem(ItemStack itemStack) {
        return itemStack.m_204117_(UP2ItemTags.PACIFIES_CARNOTAURUS);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.CARNOTAURUS_FOOD);
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 39) {
            this.roarEffect();
        }
        super.m_7822_(id);
    }

    private void roarEffect() {
        for (int i = 0; i < 10; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getChargeCooldown() > 0) {
            this.setChargeCooldown(this.getChargeCooldown() - 1);
        }
        if (this.getRoarCooldown() > 0) {
            this.setRoarCooldown(this.getRoarCooldown() - 1);
        }
        this.setAngry(this.m_21223_() < this.m_21233_() * 0.5f && !this.m_6162_());
        if (!this.m_20072_() && this.m_20089_() != Pose.SNIFFING && this.sniffCooldown > 0) {
            --this.sniffCooldown;
        }
        if (!this.m_20072_() && this.m_20089_() != UP2Poses.WAVING.get() && this.waveCooldown > 0) {
            --this.waveCooldown;
        }
        if (this.biteTicks > 0) {
            --this.biteTicks;
        }
        if (this.biteTicks == 0 && this.m_20089_() == UP2Poses.BITING.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.headbuttTicks > 0) {
            --this.headbuttTicks;
        }
        if (this.headbuttTicks == 0 && this.m_20089_() == UP2Poses.HEADBUTTING.get()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    @Override
    public void setupAnimationStates() {
        if (this.biteTicks == 0 && (this.bite1AnimationState.m_216984_() || this.bite2AnimationState.m_216984_())) {
            this.bite1AnimationState.m_216973_();
            this.bite2AnimationState.m_216973_();
        }
        this.angryAnimationState.m_246184_(this.isAngry(), this.f_19797_);
        this.idleAnimationState.m_246184_(!this.isCharging() && !this.isRoaring() && !this.m_20069_(), this.f_19797_);
        this.swimmingAnimationState.m_246184_(!this.isCharging() && !this.isRoaring() && this.m_20069_(), this.f_19797_);
        this.chargeAnimationState.m_246184_(this.isCharging(), this.f_19797_);
        this.roarAnimationState.m_246184_(this.isRoaring(), this.f_19797_);
    }

    @Override
    public float getWalkAnimationSpeed() {
        return this.m_6162_() ? 2.0f : 4.0f;
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        if (f_19806_.equals(accessor)) {
            if (this.m_20089_() == Pose.SNIFFING) {
                this.waveAnimationState.m_216973_();
                this.sniffAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == UP2Poses.WAVING.get()) {
                this.sniffAnimationState.m_216973_();
                this.waveAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == UP2Poses.BITING.get()) {
                if (this.m_217043_().m_188499_()) {
                    this.bite1AnimationState.m_216977_(this.f_19797_);
                } else {
                    this.bite2AnimationState.m_216977_(this.f_19797_);
                }
                this.biteTicks = 15;
            } else if (this.m_20089_() == UP2Poses.HEADBUTTING.get()) {
                this.headbuttAnimationState.m_216977_(this.f_19797_);
                this.headbuttTicks = 20;
            } else {
                this.bite1AnimationState.m_216973_();
                this.bite2AnimationState.m_216973_();
                this.waveAnimationState.m_216973_();
                this.sniffAnimationState.m_216973_();
                this.headbuttAnimationState.m_216973_();
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(CHARGE_COOLDOWN, (Object)200);
        this.f_19804_.m_135372_(ROARING, (Object)false);
        this.f_19804_.m_135372_(ROAR_COOLDOWN, (Object)400);
        this.f_19804_.m_135372_(ANGRY, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Charging", this.isCharging());
        compoundTag.m_128405_("ChargeCooldown", this.getChargeCooldown());
        compoundTag.m_128379_("Roaring", this.isRoaring());
        compoundTag.m_128405_("RoarCooldown", this.getRoarCooldown());
        compoundTag.m_128379_("Angry", this.isAngry());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setCharging(compoundTag.m_128471_("Charging"));
        this.setChargeCooldown(compoundTag.m_128451_("ChargeCooldown"));
        this.setRoaring(compoundTag.m_128471_("Roaring"));
        this.setRoarCooldown(compoundTag.m_128451_("RoarCooldown"));
        this.setAngry(compoundTag.m_128471_("Angry"));
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.f_19804_.m_135381_(ANGRY, (Object)angry);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public int getChargeCooldown() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_COOLDOWN);
    }

    public void setChargeCooldown(int cooldown) {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN, (Object)cooldown);
    }

    public void chargeCooldown() {
        this.f_19804_.m_135381_(CHARGE_COOLDOWN, (Object)(200 + this.m_217043_().m_188503_(200)));
    }

    public boolean isRoaring() {
        return (Boolean)this.f_19804_.m_135370_(ROARING);
    }

    public void setRoaring(boolean roaring) {
        this.f_19804_.m_135381_(ROARING, (Object)roaring);
    }

    public int getRoarCooldown() {
        return (Integer)this.f_19804_.m_135370_(ROAR_COOLDOWN);
    }

    public void setRoarCooldown(int cooldown) {
        this.f_19804_.m_135381_(ROAR_COOLDOWN, (Object)cooldown);
    }

    public void roarCooldown() {
        this.f_19804_.m_135381_(ROAR_COOLDOWN, (Object)(400 + this.m_217043_().m_188503_(400)));
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)UP2Entities.CARNOTAURUS.get()).m_20615_((Level)level);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)UP2SoundEvents.CARNOTAURUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)UP2SoundEvents.CARNOTAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.CARNOTAURUS_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_((SoundEvent)UP2SoundEvents.CARNOTAURUS_STEP.get(), this.m_6162_() ? 0.25f : 1.0f, this.m_6162_() ? 1.2f : 0.9f);
    }

    public int m_8100_() {
        return 180;
    }
}

