/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.GroundseekingRandomSwimGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.PrehistoricNearestAttackableTargetGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.dunkleosteus.DunkleosteusAttackGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.dunkleosteus.DunkleosteusHurtByTargetGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.dunkleosteus.DunkleosteusNearestAttackableTargetGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.dunkleosteus.DunkleosteusPanicGoal;
import com.barlinc.unusual_prehistory.entity.base.PrehistoricAquaticMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2Items;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2EntityTags;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Dunkleosteus
extends PrehistoricAquaticMob {
    private static final EntityDimensions SMALL_SIZE = EntityDimensions.m_20395_((float)0.5f, (float)0.5f);
    private static final EntityDimensions MEDIUM_SIZE = EntityDimensions.m_20395_((float)0.8f, (float)0.98f);
    private static final EntityDimensions LARGE_SIZE = EntityDimensions.m_20395_((float)1.7f, (float)1.98f);
    public final AnimationState bitingAnimationState = new AnimationState();
    public final AnimationState quirkAnimationState = new AnimationState();
    private int biteTicks;
    private final byte QUIRK = (byte)66;

    public Dunkleosteus(EntityType<? extends PrehistoricAquaticMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1000, 4, 0.02f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 5);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new DunkleosteusPanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DunkleosteusAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GroundseekingRandomSwimGoal((PathfinderMob)this, 1.0, 70, 16, 16, 0.02));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.DUNKLEOSTEUS_FOOD), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(0, (Goal)new DunkleosteusHurtByTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DunkleosteusNearestAttackableTargetGoal(this));
        this.f_21346_.m_25352_(2, new PrehistoricNearestAttackableTargetGoal<Player>(this, Player.class, 300, true, true, this::canAttackPlayer));
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.f_19862_) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3 * (double)this.m_6113_(), 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.biteTicks > 0) {
            --this.biteTicks;
        }
        if (this.biteTicks == 0 && this.m_20089_() == UP2Poses.BITING.get()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.biteTicks == 0 && this.bitingAnimationState.m_216984_()) {
            this.bitingAnimationState.m_216973_();
        }
        this.bitingAnimationState.m_246184_(this.getAttackState() == 1, this.f_19797_);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        if (VARIANT.equals(accessor)) {
            this.m_6210_();
            this.m_21051_(Attributes.f_22276_).m_22100_((double)(10.0f * (float)this.getVariant() + 10.0f));
            this.m_21051_(Attributes.f_22284_).m_22100_((double)(2.0f * (float)this.getVariant()));
            this.m_21051_(Attributes.f_22281_).m_22100_((double)(2.0f * (float)this.getVariant() + 3.0f));
            this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.9f - (float)this.getVariant() * 0.1f));
            this.m_21051_(Attributes.f_22278_).m_22100_((double)(0.1f + (float)this.getVariant() * 0.3f));
            this.m_5634_(50.0f);
        }
        if (f_19806_.equals(accessor)) {
            if (this.m_20089_() == UP2Poses.BITING.get()) {
                this.bitingAnimationState.m_216977_(this.f_19797_);
                this.biteTicks = 10;
            } else {
                this.bitingAnimationState.m_216973_();
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    public void setupAnimationCooldowns() {
        if (this.m_20072_() && this.getBehavior().equals(Behaviors.IDLE.getName()) && !this.quirkAnimationState.m_216984_() && this.f_19796_.m_188503_(600) == 0) {
            this.m_9236_().m_7605_((Entity)this, this.QUIRK);
        }
    }

    @Override
    public void m_7822_(byte id) {
        if (id == this.QUIRK) {
            this.quirkAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.DUNKLEOSTEUS_FOOD);
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public boolean isTarget(Entity entity) {
        if (this.getVariant() == 1) {
            return entity.m_6095_().m_204039_(UP2EntityTags.MEDIUM_DUNKLEOSTEUS_TARGETS);
        }
        if (this.getVariant() == 2) {
            return entity.m_6095_().m_204039_(UP2EntityTags.BIG_DUNKLEOSTEUS_TARGETS);
        }
        return entity.m_6095_().m_204039_(UP2EntityTags.SMALL_DUNKLEOSTEUS_TARGETS);
    }

    public boolean canAttackPlayer(LivingEntity entity) {
        return this.m_6779_(entity) && this.getVariant() > 0;
    }

    public boolean m_6779_(@NotNull LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (prev && this.isPacified() && entity instanceof LivingEntity && (this.m_21188_() == null || !this.m_21188_().m_20148_().equals(entity.m_20148_()))) {
            return false;
        }
        return prev;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)UP2SoundEvents.DUNKLEOSTEUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.DUNKLEOSTEUS_DEATH.get();
    }

    @Override
    protected SoundEvent getFlopSound() {
        return (SoundEvent)UP2SoundEvents.DUNKLEOSTEUS_FLOP.get();
    }

    public SoundEvent getBiteSound() {
        if (this.getVariant() == 0) {
            return (SoundEvent)UP2SoundEvents.SMALL_DUNKLEOSTEUS_BITE.get();
        }
        if (this.getVariant() == 1) {
            return (SoundEvent)UP2SoundEvents.MEDIUM_DUNKLEOSTEUS_BITE.get();
        }
        return (SoundEvent)UP2SoundEvents.LARGE_DUNKLEOSTEUS_BITE.get();
    }

    public float m_6100_() {
        float size = (float)(3 - this.getVariant()) * 0.33f;
        return (float)((double)super.m_6100_() * Math.sqrt(size) * (double)1.2f);
    }

    public boolean m_6094_() {
        return super.m_6094_() && this.getVariant() != 2;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return this.getDimsForDunk().m_20388_(this.m_6134_());
    }

    private EntityDimensions getDimsForDunk() {
        return switch (this.getVariant()) {
            case 1 -> MEDIUM_SIZE;
            case 2 -> LARGE_SIZE;
            default -> SMALL_SIZE;
        };
    }

    @Override
    public boolean canPacifiy() {
        return true;
    }

    @Override
    public boolean isPacifyItem(ItemStack itemStack) {
        return itemStack.m_204117_(UP2ItemTags.PACIFIES_DUNKLEOSTEUS);
    }

    @javax.annotation.Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        Dunkleosteus dunkleosteus = (Dunkleosteus)((EntityType)UP2Entities.DUNKLEOSTEUS.get()).m_20615_((Level)serverLevel);
        dunkleosteus.setVariant(this.getVariant());
        return dunkleosteus;
    }

    @NotNull
    public ItemStack m_28282_() {
        return this.getVariant() == 0 ? new ItemStack((ItemLike)UP2Items.DUNKLEOSTEUS_BUCKET.get()) : ItemStack.f_41583_;
    }

    @Override
    public int getVariantCount() {
        return DunkleosteusVariant.values().length;
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(level, difficulty, spawnType, spawnGroupData, compoundTag);
        if (spawnType == MobSpawnType.BUCKET && compoundTag != null && compoundTag.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compoundTag.m_128451_("BucketVariantTag"));
        } else {
            this.setVariant(this.f_19796_.m_188503_(DunkleosteusVariant.values().length));
        }
        return spawnGroupData;
    }

    public static enum DunkleosteusVariant {
        RAVERI(0),
        MARSAISI(1),
        TERRELLI(2);

        private final int id;

        private DunkleosteusVariant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static DunkleosteusVariant byId(int id) {
            if (id < 0 || id >= DunkleosteusVariant.values().length) {
                id = 0;
            }
            return DunkleosteusVariant.values()[id];
        }
    }
}

