/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity;

import com.barlinc.unusual_prehistory.entity.ai.goals.CustomizableRandomSwimGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.LargeBabyPanicGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.LeaveWaterGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.PrehistoricNearestAttackableTargetGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.SemiAquaticRandomStrollGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.megalania.MegalaniaAttackGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.megalania.MegalaniaLayDownGoal;
import com.barlinc.unusual_prehistory.entity.ai.goals.megalania.MegalaniaRoarGoal;
import com.barlinc.unusual_prehistory.entity.ai.navigation.SmoothGroundPathNavigation;
import com.barlinc.unusual_prehistory.entity.base.SemiAquaticMob;
import com.barlinc.unusual_prehistory.entity.utils.Behaviors;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2Entities;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import com.barlinc.unusual_prehistory.registry.tags.UP2EntityTags;
import com.barlinc.unusual_prehistory.registry.tags.UP2ItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Megalania
extends SemiAquaticMob {
    private static final EntityDataAccessor<Integer> TEMPERATURE_STATE = SynchedEntityData.m_135353_(Megalania.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PREV_TEMPERATURE_STATE = SynchedEntityData.m_135353_(Megalania.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LAY_DOWN_COOLDOWN = SynchedEntityData.m_135353_(Megalania.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.m_20395_((float)1.7f, (float)1.05f);
    public TemperatureStates localTemperatureState = TemperatureStates.TEMPERATE;
    public float tempProgress = 0.0f;
    public float prevTempProgress = 0.0f;
    @Nullable
    private SemiAquaticRandomStrollGoal randomStrollGoal;
    public int roarCooldown = 300 + this.m_217043_().m_188503_(3600);
    private final byte TONGUE = (byte)66;
    private final byte FLICK1 = (byte)67;
    private final byte FLICK2 = (byte)68;
    private final byte YAWN = (byte)69;
    private final byte STOP = (byte)70;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    public final AnimationState tongueAnimationState = new AnimationState();
    public final AnimationState roaringAnimationState = new AnimationState();
    public final AnimationState biting1AnimationState = new AnimationState();
    public final AnimationState biting2AnimationState = new AnimationState();
    public final AnimationState tailWhipAnimationState = new AnimationState();
    public final AnimationState leapingAnimationState = new AnimationState();
    public final AnimationState aggroAnimationState = new AnimationState();
    public final AnimationState flick1AnimationState = new AnimationState();
    public final AnimationState flick2AnimationState = new AnimationState();
    public final AnimationState yawnAnimationState = new AnimationState();
    public final AnimationState layDownAnimationState = new AnimationState();
    public final AnimationState sittingAnimationState = new AnimationState();
    public final AnimationState standUpAnimationState = new AnimationState();
    private int bitingTicks;
    private int tailWhipTicks;
    private int roarTicks;

    public Megalania(EntityType<? extends Megalania> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.switchNavigator(true);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.randomStrollGoal = new SemiAquaticRandomStrollGoal(this, 1.0);
        this.f_21345_.m_25352_(0, (Goal)new LeaveWaterGoal(this, 1.0, 1200, 2400));
        this.f_21345_.m_25352_(1, (Goal)new MegalaniaAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LargeBabyPanicGoal(this, 1.6));
        this.f_21345_.m_25352_(3, (Goal)new CustomizableRandomSwimGoal((PathfinderMob)this, 1.0, 50, 10, 5, 3));
        this.f_21345_.m_25352_(3, (Goal)this.randomStrollGoal);
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(UP2ItemTags.MEGALANIA_FOOD), false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new MegalaniaRoarGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new MegalaniaLayDownGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, new PrehistoricNearestAttackableTargetGoal<Player>(this, Player.class, 200, true, false, this::isHostileToPlayers));
        this.f_21346_.m_25352_(2, new PrehistoricNearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 500, true, false, entity -> entity.m_6095_().m_204039_(UP2EntityTags.MEGALANIA_TARGETS)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, (double)0.16f).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new SmoothGroundPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new LookControl((Mob)this);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1000, 10, 0.6f, 0.1f, false);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
            this.isLandNavigator = false;
        }
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.refuseToMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            travelVector = travelVector.m_82542_(0.0, 1.0, 0.0);
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean isHostileToPlayers(LivingEntity entity) {
        return this.m_6779_(entity) && (this.getTemperatureState() == TemperatureStates.WARM || this.getTemperatureState() == TemperatureStates.NETHER);
    }

    @Override
    public boolean canPacifiy() {
        return true;
    }

    @Override
    public boolean isPacifyItem(ItemStack itemStack) {
        return itemStack.m_204117_(UP2ItemTags.PACIFIES_MEGALANIA);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UP2ItemTags.MEGALANIA_FOOD);
    }

    public boolean m_5825_() {
        return this.getTemperatureState() == TemperatureStates.NETHER;
    }

    public void applyPoison(@NotNull LivingEntity entity) {
        float chance = 0.0f;
        int i = 0;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            i = 5;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            i = 10;
        }
        if (this.getTemperatureState() == TemperatureStates.COLD) {
            chance = -0.1f;
        } else if (this.getTemperatureState() == TemperatureStates.WARM) {
            chance = 0.1f;
        } else if (this.getTemperatureState() == TemperatureStates.NETHER) {
            chance = 0.2f;
        }
        if (i > 0 && this.m_217043_().m_188501_() < 0.3f + chance) {
            entity.m_147207_(new MobEffectInstance(this.getTemperatureState() == TemperatureStates.NETHER ? MobEffects.f_19615_ : MobEffects.f_19614_, i * 40, 0), (Entity)this);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEMPERATURE_STATE, (Object)0);
        this.f_19804_.m_135372_(PREV_TEMPERATURE_STATE, (Object)-1);
        this.f_19804_.m_135372_(LAY_DOWN_COOLDOWN, (Object)(2500 + this.m_217043_().m_188503_(2400)));
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("TemperatureState", this.getTemperatureState().ordinal());
        compoundTag.m_128405_("LayDownCooldown", this.getLayDownCooldown());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(TEMPERATURE_STATE, (Object)compoundTag.m_128451_("TemperatureState"));
        this.setLayDownCooldown(compoundTag.m_128451_("LayDownCooldown"));
    }

    public TemperatureStates getTemperatureState() {
        return TemperatureStates.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(TEMPERATURE_STATE)), (int)0, (int)3)];
    }

    public void setTemperatureState(TemperatureStates state) {
        if (this.getTemperatureState() != state) {
            this.f_19804_.m_135381_(PREV_TEMPERATURE_STATE, (Object)((Integer)this.f_19804_.m_135370_(TEMPERATURE_STATE)));
        }
        this.f_19804_.m_135381_(TEMPERATURE_STATE, (Object)state.ordinal());
    }

    public TemperatureStates getPrevTemperatureState() {
        if ((Integer)this.f_19804_.m_135370_(PREV_TEMPERATURE_STATE) == -1) {
            return null;
        }
        return TemperatureStates.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(PREV_TEMPERATURE_STATE)), (int)0, (int)3)];
    }

    public int getLayDownCooldown() {
        return (Integer)this.f_19804_.m_135370_(LAY_DOWN_COOLDOWN);
    }

    public void setLayDownCooldown(int cooldown) {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)cooldown);
    }

    public void layDownCooldown() {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)(3500 + this.f_19796_.m_188503_(2800)));
    }

    public void standUpCooldown() {
        this.f_19804_.m_135381_(LAY_DOWN_COOLDOWN, (Object)(800 + this.f_19796_.m_188503_(2000)));
    }

    public boolean isMegalaniaLayingDown() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isMegalaniaVisuallyLayingDown() {
        return this.getPoseTime() < 0L != this.isMegalaniaLayingDown();
    }

    @Override
    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < 20L;
    }

    private boolean isVisuallyLayingDown() {
        return this.isMegalaniaLayingDown() && this.getPoseTime() < 20L && this.getPoseTime() >= 0L;
    }

    public void layDown() {
        if (this.isMegalaniaLayingDown()) {
            return;
        }
        this.m_20124_(UP2Poses.RESTING.get());
        this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void standUp() {
        if (!this.isMegalaniaLayingDown()) {
            return;
        }
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    public void standUpInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
        this.m_6210_();
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return pose == UP2Poses.RESTING.get() ? SITTING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public boolean m_5829_() {
        return this.isMegalaniaLayingDown();
    }

    protected void m_7880_(float distance) {
        if (distance > 6.0f && this.isMegalaniaLayingDown() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float amount) {
        this.standUpInstantly();
        super.m_6475_(damageSource, amount);
    }

    @Override
    public boolean refuseToMove() {
        return this.isMegalaniaLayingDown() || this.isInPoseTransition() || this.m_20089_() == Pose.ROARING;
    }

    @Override
    public void m_8119_() {
        boolean ground;
        super.m_8119_();
        boolean bl = ground = !this.m_20069_();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.roarCooldown > 0 && !this.m_20072_() && this.getBehavior().equals(Behaviors.IDLE.getName())) {
            --this.roarCooldown;
        }
        if (this.bitingTicks > 0) {
            --this.bitingTicks;
        }
        if (this.bitingTicks == 0 && this.m_20089_() == UP2Poses.BITING.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.tailWhipTicks > 0) {
            --this.tailWhipTicks;
        }
        if (this.tailWhipTicks == 0 && this.m_20089_() == UP2Poses.TAIL_WHIPPING.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.roarTicks > 0) {
            --this.roarTicks;
        }
        if (this.roarTicks == 0 && this.m_20089_() == Pose.ROARING) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.isMegalaniaLayingDown() && this.m_20072_()) {
            this.standUpInstantly();
        }
        if (this.m_9236_().m_45527_(this.m_20183_()) && (this.m_9236_().m_46470_() || this.m_9236_().m_46471_()) || !this.isRightTemperatureToSit()) {
            this.standUp();
        }
        this.tickTemperatureStates();
    }

    public boolean isRightTemperatureToSit() {
        return this.getTemperatureState() == TemperatureStates.TEMPERATE || this.getTemperatureState() == TemperatureStates.COLD;
    }

    private void tickTemperatureStates() {
        if (!this.m_9236_().f_46443_) {
            if (((Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_()).m_47554_() >= 1.0f) {
                if (this.m_9236_().m_46472_() == Level.f_46429_) {
                    this.setTemperatureState(TemperatureStates.NETHER);
                } else {
                    this.setTemperatureState(TemperatureStates.WARM);
                }
            } else if (((Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_()).m_47554_() <= 0.0f) {
                this.setTemperatureState(TemperatureStates.COLD);
            } else {
                this.setTemperatureState(TemperatureStates.TEMPERATE);
            }
        } else {
            this.prevTempProgress = this.tempProgress;
            if (this.localTemperatureState != this.getPrevTemperatureState()) {
                this.localTemperatureState = this.getPrevTemperatureState();
                this.tempProgress = 0.0f;
            }
            if (this.getPrevTemperatureState() != this.getTemperatureState() && this.tempProgress < 5.0f) {
                this.tempProgress += 0.05f;
            }
            if (this.getPrevTemperatureState() == this.getTemperatureState() && this.tempProgress > 0.0f) {
                this.tempProgress -= 0.05f;
            }
        }
    }

    @Override
    public void setupAnimationStates() {
        if (this.bitingTicks == 0 && (this.biting1AnimationState.m_216984_() || this.biting2AnimationState.m_216984_())) {
            this.biting1AnimationState.m_216973_();
            this.biting2AnimationState.m_216973_();
        }
        if (this.tailWhipTicks == 0 && this.tailWhipAnimationState.m_216984_()) {
            this.tailWhipAnimationState.m_216973_();
        }
        this.idleAnimationState.m_246184_(!this.m_20072_() && this.m_20089_() != Pose.ROARING && this.m_20089_() != UP2Poses.TAIL_WHIPPING.get(), this.f_19797_);
        this.swimmingAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
        this.aggroAnimationState.m_246184_(this.getBehavior().equals(Behaviors.ANGRY.getName()) && this.m_20089_() == Pose.STANDING, this.f_19797_);
        if (this.isMegalaniaVisuallyLayingDown()) {
            this.standUpAnimationState.m_216973_();
            this.biting1AnimationState.m_216973_();
            this.biting2AnimationState.m_216973_();
            this.roaringAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            this.aggroAnimationState.m_216973_();
            this.tailWhipAnimationState.m_216973_();
            if (this.isVisuallyLayingDown()) {
                this.layDownAnimationState.m_216982_(this.f_19797_);
                this.sittingAnimationState.m_216973_();
            } else {
                this.layDownAnimationState.m_216973_();
                this.sittingAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.layDownAnimationState.m_216973_();
            this.sittingAnimationState.m_216973_();
            this.standUpAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    @Override
    public void setupAnimationCooldowns() {
        if (this.getBehavior().equals(Behaviors.IDLE.getName()) && !this.m_20072_() && !this.m_5912_()) {
            if (this.getLayDownCooldown() > 0) {
                this.setLayDownCooldown(this.getLayDownCooldown() - 1);
            }
            if (this.m_20089_() == Pose.STANDING) {
                if (this.f_19796_.m_188503_(200) == 0) {
                    this.m_9236_().m_7605_((Entity)this, this.TONGUE);
                } else if (this.f_19796_.m_188503_(800) == 0 && !this.flickAnimationStarted()) {
                    this.m_9236_().m_7605_((Entity)this, this.FLICK1);
                } else if (this.f_19796_.m_188503_(800) == 0 && !this.flickAnimationStarted()) {
                    this.m_9236_().m_7605_((Entity)this, this.FLICK2);
                } else if (this.f_19796_.m_188503_(700) == 0 && !this.tongueAnimationState.m_216984_()) {
                    this.m_9236_().m_7605_((Entity)this, this.YAWN);
                }
            }
        }
    }

    private boolean flickAnimationStarted() {
        return this.flick1AnimationState.m_216984_() || this.flick2AnimationState.m_216984_();
    }

    @Override
    public void m_7822_(byte id) {
        if (id == this.TONGUE) {
            this.tongueAnimationState.m_216977_(this.f_19797_);
        } else if (id == this.FLICK1) {
            this.flick1AnimationState.m_216977_(this.f_19797_);
        } else if (id == this.FLICK2) {
            this.flick2AnimationState.m_216977_(this.f_19797_);
        } else if (id == this.YAWN) {
            this.yawnAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        if (f_19806_.equals(accessor)) {
            if (this.m_20089_() == Pose.ROARING) {
                this.idleAnimationState.m_216973_();
                this.tongueAnimationState.m_216973_();
                this.tailWhipAnimationState.m_216973_();
                this.biting1AnimationState.m_216973_();
                this.biting2AnimationState.m_216973_();
                this.swimmingAnimationState.m_216973_();
                this.leapingAnimationState.m_216973_();
                this.flick2AnimationState.m_216973_();
                this.flick1AnimationState.m_216973_();
                this.roarTicks = 80;
                this.roaringAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == UP2Poses.BITING.get()) {
                this.bitingTicks = 20;
                if (this.m_217043_().m_188499_()) {
                    this.biting1AnimationState.m_216977_(this.f_19797_);
                } else {
                    this.biting2AnimationState.m_216977_(this.f_19797_);
                }
            } else if (this.m_20089_() == UP2Poses.TAIL_WHIPPING.get()) {
                this.tailWhipTicks = 30;
                this.tailWhipAnimationState.m_216977_(this.f_19797_);
            } else {
                this.roaringAnimationState.m_216973_();
                this.biting1AnimationState.m_216973_();
                this.biting2AnimationState.m_216973_();
                this.tailWhipAnimationState.m_216973_();
            }
        }
        if (TEMPERATURE_STATE.equals(accessor)) {
            if (this.getTemperatureState().equals((Object)TemperatureStates.COLD)) {
                this.m_21051_(Attributes.f_22279_).m_22100_((double)0.12f);
                if (this.randomStrollGoal != null) {
                    this.randomStrollGoal.m_25746_(200);
                }
            } else if (this.getTemperatureState().equals((Object)TemperatureStates.TEMPERATE)) {
                this.m_21051_(Attributes.f_22279_).m_22100_((double)0.16f);
                if (this.randomStrollGoal != null) {
                    this.randomStrollGoal.m_25746_(120);
                }
            } else if (this.getTemperatureState().equals((Object)TemperatureStates.WARM)) {
                this.m_21051_(Attributes.f_22279_).m_22100_((double)0.19f);
                if (this.randomStrollGoal != null) {
                    this.randomStrollGoal.m_25746_(80);
                }
            } else if (this.getTemperatureState().equals((Object)TemperatureStates.NETHER)) {
                this.m_21051_(Attributes.f_22279_).m_22100_((double)0.22f);
                if (this.randomStrollGoal != null) {
                    this.randomStrollGoal.m_25746_(50);
                }
            }
        }
        super.m_7350_(accessor);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)UP2Entities.MEGALANIA.get()).m_20615_((Level)level);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)UP2SoundEvents.MEGALANIA_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)UP2SoundEvents.MEGALANIA_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)UP2SoundEvents.MEGALANIA_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.m_5496_(SoundEvents.f_244506_, 1.0f, 0.9f);
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag compoundTag) {
        this.f_19804_.m_135381_(PREV_TEMPERATURE_STATE, (Object)0);
        this.setTemperatureState(TemperatureStates.TEMPERATE);
        return super.m_6518_(levelAccessor, difficulty, spawnType, spawnDataIn, compoundTag);
    }

    public static enum TemperatureStates {
        TEMPERATE,
        COLD,
        WARM,
        NETHER;

    }
}

