/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.ai.goals.carnotaurus;

import com.barlinc.unusual_prehistory.entity.Carnotaurus;
import com.barlinc.unusual_prehistory.entity.ai.goals.AttackGoal;
import com.barlinc.unusual_prehistory.entity.utils.UP2Poses;
import com.barlinc.unusual_prehistory.registry.UP2SoundEvents;
import java.util.Objects;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CarnotaurusAttackGoal
extends AttackGoal {
    private final Carnotaurus carnotaurus;

    public CarnotaurusAttackGoal(Carnotaurus carnotaurus) {
        super(carnotaurus);
        this.carnotaurus = carnotaurus;
    }

    public void m_8037_() {
        LivingEntity target = this.carnotaurus.m_5448_();
        if (target != null) {
            this.carnotaurus.m_21391_((Entity)this.carnotaurus.m_5448_(), 30.0f, 30.0f);
            this.carnotaurus.m_21563_().m_24960_((Entity)this.carnotaurus.m_5448_(), 30.0f, 30.0f);
            double distance = this.carnotaurus.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            int attackState = this.carnotaurus.getAttackState();
            if (attackState == 1) {
                this.tickBite();
                this.carnotaurus.m_21573_().m_5624_((Entity)target, 1.75);
            } else if (attackState == 2) {
                this.tickHeadbutt();
            } else {
                this.carnotaurus.m_21573_().m_5624_((Entity)target, 2.0);
                if (distance <= 10.0) {
                    if (this.carnotaurus.m_217043_().m_188499_()) {
                        this.carnotaurus.setAttackState(1);
                    } else {
                        this.carnotaurus.setAttackState(2);
                    }
                }
            }
        }
    }

    protected void tickBite() {
        ++this.timer;
        LivingEntity target = this.carnotaurus.m_5448_();
        if (this.timer == 1) {
            this.carnotaurus.m_20124_(UP2Poses.BITING.get());
        }
        if (this.timer == 9) {
            this.carnotaurus.m_5496_((SoundEvent)UP2SoundEvents.CARNOTAURUS_BITE.get(), 1.0f, this.carnotaurus.m_6100_());
        }
        if (this.timer == 11 && (double)this.carnotaurus.m_20270_((Entity)Objects.requireNonNull(target)) <= this.getAttackReachSqr(target)) {
            this.carnotaurus.m_6674_(InteractionHand.MAIN_HAND);
            this.carnotaurus.m_7327_((Entity)target);
        }
        if (this.timer > 22) {
            this.timer = 0;
            this.carnotaurus.setAttackState(0);
        }
    }

    protected void tickHeadbutt() {
        ++this.timer;
        LivingEntity target = this.carnotaurus.m_5448_();
        this.carnotaurus.m_21573_().m_26573_();
        if (this.timer == 1) {
            this.carnotaurus.m_20124_(UP2Poses.HEADBUTTING.get());
        }
        if (this.timer == 9) {
            this.carnotaurus.m_246865_(this.carnotaurus.m_20154_().m_82490_(2.0).m_82542_(0.25, 0.0, 0.25));
        }
        if (this.timer == 12 && (double)this.carnotaurus.m_20270_((Entity)Objects.requireNonNull(target)) <= this.getAttackReachSqr(target)) {
            this.carnotaurus.m_6674_(InteractionHand.MAIN_HAND);
            if (this.carnotaurus.m_7327_((Entity)target)) {
                this.carnotaurus.m_5496_((SoundEvent)UP2SoundEvents.CARNOTAURUS_HEADBUTT.get(), 1.0f, this.carnotaurus.m_6100_());
            }
            this.carnotaurus.strongKnockback((Entity)target, 1.5, 0.5);
            if (target.m_21275_(this.carnotaurus.m_269291_().m_269333_((LivingEntity)this.carnotaurus)) && target instanceof Player) {
                Player player = (Player)target;
                player.m_36384_(true);
            }
        }
        if (this.timer > 28) {
            this.timer = 0;
            this.carnotaurus.setAttackState(0);
        }
    }

    @Override
    protected double getAttackReachSqr(LivingEntity target) {
        return this.mob.m_20205_() * 1.35f * this.mob.m_20205_() * 1.35f + target.m_20205_();
    }
}

