/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.entity.base;

import com.barlinc.unusual_prehistory.entity.base.PrehistoricMob;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;

public abstract class TameablePrehistoricMob
extends PrehistoricMob
implements OwnableEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(TameablePrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(TameablePrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(TameablePrehistoricMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean orderedToSit;

    protected TameablePrehistoricMob(EntityType<? extends PrehistoricMob> entityType, Level level) {
        super(entityType, level);
        this.reassessTameGoals();
    }

    public void m_7023_(@NotNull Vec3 travelVec) {
        if (this.isInSittingPose()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVec = Vec3.f_82478_;
        }
        super.m_7023_(travelVec);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.m_21805_() != null) {
            compoundTag.m_128362_("Owner", this.m_21805_());
        }
        compoundTag.m_128379_("Sitting", this.orderedToSit);
        compoundTag.m_128405_("Command", this.getCommand());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        UUID uuid;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String s = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
        this.orderedToSit = compoundTag.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
        this.setCommand(compoundTag.m_128451_("Command"));
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!tamed) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean pTamed) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (pTamed) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0 && !this.m_20160_() && !this.m_20159_();
    }

    public void setInSittingPose(boolean sitting) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (sitting) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
        }
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        return !this.isOwnedBy(target) && super.m_6779_(target);
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.m_269323_();
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return true;
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.m_269323_()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(@NotNull Entity entity) {
        if (this.isTame()) {
            LivingEntity owner = this.m_269323_();
            if (entity == owner) {
                return true;
            }
            if (entity instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)entity;
                return tamableAnimal.m_21830_(owner);
            }
            if (entity instanceof TameablePrehistoricMob) {
                TameablePrehistoricMob tameablePrehistoricMob = (TameablePrehistoricMob)entity;
                return tameablePrehistoricMob.isOwnedBy(owner);
            }
            if (owner != null) {
                return owner.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public void m_6667_(@NotNull DamageSource source) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(source);
        if (this.f_20890_ && !this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(deathMessage);
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
        InteractionResult type = super.m_6071_(player, hand);
        if (!interactionresult.m_19077_() && !type.m_19077_() && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.m_6898_(itemstack)) {
            if (this.canOwnerCommand(player)) {
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() == 3) {
                    this.setCommand(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)("entity.unusual_prehistory.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
                boolean sit = this.getCommand() == 1;
                this.setOrderedToSit(sit);
                return InteractionResult.SUCCESS;
            }
            if (this.canOwnerMount(player)) {
                if (!this.m_9236_().f_46443_ && player.m_20329_((Entity)this)) {
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return type;
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean orderedToSit) {
        this.orderedToSit = orderedToSit;
    }

    public boolean canOwnerMount(Player player) {
        return false;
    }

    public boolean canOwnerCommand(Player ownerPlayer) {
        return false;
    }
}

