/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.events;

import com.barlinc.unusual_prehistory.UnusualPrehistory2;
import com.barlinc.unusual_prehistory.events.ScreenShakeEvent;
import com.barlinc.unusual_prehistory.registry.UP2MapIcons;
import com.barlinc.unusual_prehistory.utils.ClientProxy;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="unusual_prehistory", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientForgeEvents {
    private static float shakeAmount;
    private static float prevShakeAmount;
    public static final List<ScreenShakeEvent> SCREEN_SHAKE_EVENTS;
    public static PoseStack lastMapPoseStack;
    public static MultiBufferSource lastMapRenderBuffer;
    public static int lastMapRenderPackedLight;
    private static final RenderType FOSSIL_SITE_MAP_ICONS;

    @SubscribeEvent
    public void preRenderLiving(RenderLivingEvent.Pre event) {
        if (ClientProxy.blockedEntityRenders.contains(event.getEntity().m_20148_())) {
            if (!UnusualPrehistory2.PROXY.isFirstPersonPlayer((Entity)event.getEntity())) {
                MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(event.getEntity(), event.getRenderer(), event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight()));
                event.setCanceled(true);
            }
            ClientProxy.blockedEntityRenders.remove(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END) {
            Entity cameraEntity = minecraft.m_91288_();
            prevShakeAmount = shakeAmount;
            float shake = 0.0f;
            Iterator<ScreenShakeEvent> groundShakeMomentIterator = SCREEN_SHAKE_EVENTS.iterator();
            while (groundShakeMomentIterator.hasNext()) {
                ScreenShakeEvent groundShakeMoment = groundShakeMomentIterator.next();
                groundShakeMoment.tick();
                if (groundShakeMoment.isDone()) {
                    groundShakeMomentIterator.remove();
                    continue;
                }
                shake = Math.max(shake, groundShakeMoment.getDegree(cameraEntity, 1.0f));
            }
            shakeAmount = shake * ((Double)minecraft.f_91066_.m_231924_().m_231551_()).floatValue();
        }
    }

    @SubscribeEvent
    public void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Minecraft minecraft = Minecraft.m_91087_();
        float partialTicks = (float)event.getPartialTick();
        float lerpedShakeAmount = Mth.m_14036_((float)(prevShakeAmount + (shakeAmount - prevShakeAmount) * partialTicks), (float)0.0f, (float)4.0f);
        if (lerpedShakeAmount > 0.0f) {
            float time = minecraft.f_91075_ == null ? 0.0f : (float)minecraft.f_91075_.f_19797_ + minecraft.getPartialTick();
            event.setRoll((float)((double)lerpedShakeAmount * Math.sin(2.0f * time)));
        }
    }

    public static void renderMapDecoration(MapDecoration mapdecoration, int k) {
        if (mapdecoration.m_77803_() == UP2MapIcons.FOSSIL_SITE_MAP_DECORATION) {
            MultiBufferSource multiBufferSource = lastMapRenderBuffer == null ? Minecraft.m_91087_().m_91269_().m_110104_() : lastMapRenderBuffer;
            PoseStack poseStack = lastMapPoseStack == null ? new PoseStack() : lastMapPoseStack;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f + (float)mapdecoration.m_77804_() / 2.0f + 64.0f, 0.0f + (float)mapdecoration.m_77805_() / 2.0f + 64.0f, -0.02f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(mapdecoration.m_77806_() * 360) / 16.0f));
            poseStack.m_85841_(4.0f, 4.0f, 3.0f);
            poseStack.m_252880_(-0.125f, 0.125f, 0.0f);
            byte iconOrdinal = UP2MapIcons.getMapIconRenderOrdinal(mapdecoration.m_77803_());
            float f1 = (float)(iconOrdinal % 16 + 0) / 16.0f;
            float f2 = (float)(iconOrdinal / 16 + 0) / 16.0f;
            float f3 = (float)(iconOrdinal % 16 + 1) / 16.0f;
            float f4 = (float)(iconOrdinal / 16 + 1) / 16.0f;
            Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
            VertexConsumer icons = multiBufferSource.m_6299_(FOSSIL_SITE_MAP_ICONS);
            icons.m_252986_(matrix4f1, -1.0f, 1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f1, f2).m_85969_(lastMapRenderPackedLight).m_5752_();
            icons.m_252986_(matrix4f1, 1.0f, 1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f3, f2).m_85969_(lastMapRenderPackedLight).m_5752_();
            icons.m_252986_(matrix4f1, 1.0f, -1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f3, f4).m_85969_(lastMapRenderPackedLight).m_5752_();
            icons.m_252986_(matrix4f1, -1.0f, -1.0f, (float)k * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f1, f4).m_85969_(lastMapRenderPackedLight).m_5752_();
            poseStack.m_85849_();
            if (mapdecoration.m_77810_() != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                Component component = mapdecoration.m_77810_();
                float f6 = font.m_92852_((FormattedText)component);
                float f7 = Mth.m_14036_((float)(25.0f / f6), (float)0.0f, (float)0.6666667f);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f + (float)mapdecoration.m_77804_() / 2.0f + 64.0f - f6 * f7 / 2.0f, 0.0f + (float)mapdecoration.m_77805_() / 2.0f + 64.0f + 4.0f, -0.025f);
                poseStack.m_85841_(f7, f7, 1.0f);
                poseStack.m_252880_(0.0f, 0.0f, -0.1f);
                font.m_272077_(component, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, lastMapRenderPackedLight);
                poseStack.m_85849_();
            }
        }
    }

    static {
        SCREEN_SHAKE_EVENTS = new ArrayList<ScreenShakeEvent>();
        FOSSIL_SITE_MAP_ICONS = RenderType.m_110497_((ResourceLocation)UnusualPrehistory2.modPrefix("textures/map/fossil_site_icons.png"));
    }
}

