/*
 * Decompiled with CFR 0.152.
 */
package com.barlinc.unusual_prehistory.modifier;

import com.barlinc.unusual_prehistory.registry.UP2MapIcons;
import com.barlinc.unusual_prehistory.registry.tags.UP2StructureTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.NotNull;

public class FossilSiteMapLootModifier
implements IGlobalLootModifier {
    public static final Supplier<Codec<FossilSiteMapLootModifier>> CODEC = () -> RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(modifier -> modifier.conditions), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(modifier -> Float.valueOf(modifier.chance))).apply((Applicative)instance, FossilSiteMapLootModifier::new));
    private final LootItemCondition[] conditions;
    private final Predicate<LootContext> orConditions;
    private final float chance;

    protected FossilSiteMapLootModifier(LootItemCondition[] conditions, float chance) {
        this.conditions = conditions;
        this.orConditions = LootItemConditions.m_81841_((Predicate[])conditions);
        this.chance = chance;
    }

    @NotNull
    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return this.orConditions.test(context) ? this.doApply(generatedLoot, context) : generatedLoot;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockPos chestPos;
        ServerLevel serverlevel;
        BlockPos blockpos;
        if (context.m_230907_().m_188501_() < this.chance && context.m_78936_(LootContextParams.f_81460_) && (blockpos = (serverlevel = context.m_78952_()).m_215011_(UP2StructureTags.ON_FOSSIL_MAPS, chestPos = BlockPos.m_274446_((Position)((Position)context.m_165124_(LootContextParams.f_81460_))), 100, true)) != null) {
            ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
            MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)UP2MapIcons.FOSSIL_SITE_MAP_DECORATION);
            itemstack.m_41714_((Component)Component.m_237115_((String)"item.unusual_prehistory.fossil_explorer_map"));
            generatedLoot.add((Object)itemstack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

