/*
 * Decompiled with CFR 0.152.
 */
package net.lukeit.linker;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.geysermc.floodgate.api.FloodgateApi;

public class Linker
implements ModInitializer {
    private static final Gson GSON = new Gson();
    private static CommandConfig config;

    public void onInitialize() {
        this.loadConfig();
        CommandRegistrationCallback.EVENT.register(this::onRegisterCommands);
    }

    private void onRegisterCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess, class_2170.class_5364 registrationEnvironment) {
        if (config == null || Linker.config.commands == null) {
            return;
        }
        for (CommandEntry entry : Linker.config.commands) {
            String commandName = entry.name;
            LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)class_2170.method_9247((String)commandName).executes(ctx -> this.executeTransfer((CommandContext<class_2168>)ctx, entry.ip, entry.port));
            dispatcher.register(cmd);
        }
    }

    private int executeTransfer(CommandContext<class_2168> ctx, String ipArgument, Integer portArgument) {
        String targetIp;
        boolean isBedrock;
        class_2168 src = (class_2168)ctx.getSource();
        class_1297 class_12972 = src.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"[Linker] Only players can run this command."));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        try {
            isBedrock = FloodgateApi.getInstance().isFloodgatePlayer(player.method_5667());
        }
        catch (Throwable t) {
            src.method_9213((class_2561)class_2561.method_43470((String)"[Linker] Floodgate API not available."));
            return 0;
        }
        String string = ipArgument != null ? ipArgument : (targetIp = isBedrock ? "bedrock.example.com" : "java.example.com");
        int targetPort = portArgument != null ? portArgument : (isBedrock ? 19132 : 25565);
        String command = String.format("transfer %s %d", targetIp, targetPort);
        try {
            int result = src.method_9211().method_3734().method_9235().execute(command, (Object)src);
            if (result == 0) {
                src.method_9226(() -> class_2561.method_43470((String)("[Linker] Transfer command returned 0: " + command)), false);
            }
            return result;
        }
        catch (CommandSyntaxException e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[Linker] Syntax error: " + e.getMessage())));
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)"[Linker] Unexpected error. See server log."));
            e.printStackTrace();
        }
        return 0;
    }

    private void loadConfig() {
        try {
            File configFile;
            File configDir = new File("config/linker");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!(configFile = new File(configDir, "commands.json")).exists()) {
                configFile.createNewFile();
                return;
            }
            try (FileReader reader = new FileReader(configFile);){
                Type type = new TypeToken<CommandConfig>(this){}.getType();
                config = (CommandConfig)GSON.fromJson((Reader)reader, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class CommandConfig {
        public List<CommandEntry> commands;
    }

    public static class CommandEntry {
        public String name;
        public String ip;
        public Integer port;
    }
}

