/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.samplerate;

import com.sedmelluq.discord.lavaplayer.natives.samplerate.SampleRateLibrary;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.lava.common.natives.NativeResourceHolder;

public class SampleRateConverter
extends NativeResourceHolder {
    private final SampleRateLibrary library;
    private final double ratio;
    private final long instance;

    public SampleRateConverter(ResamplingType type, int channels, int sourceRate, int targetRate) {
        this.ratio = (double)targetRate / (double)sourceRate;
        this.library = SampleRateLibrary.getInstance();
        this.instance = this.library.create(type.ordinal(), channels);
        if (this.instance == 0L) {
            throw new IllegalStateException("Could not create an instance of sample rate converter.");
        }
    }

    public void reset() {
        this.checkNotReleased();
        this.library.reset(this.instance);
    }

    public void process(float[] input, int inputOffset, int inputLength, float[] output, int outputOffset, int outputLength, boolean endOfInput, Progress progress) {
        this.checkNotReleased();
        int error = this.library.process(this.instance, input, inputOffset, inputLength, output, outputOffset, outputLength, endOfInput, this.ratio, progress.fields);
        if (error != 0) {
            throw new RuntimeException("Failed to convert sample rate, error " + error + ".");
        }
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }

    public static enum ResamplingType {
        SINC_BEST_QUALITY,
        SINC_MEDIUM_QUALITY,
        SINC_FASTEST,
        ZERO_ORDER_HOLD,
        LINEAR;

    }

    public static class Progress {
        private final int[] fields = new int[2];

        public int getInputUsed() {
            return this.fields[0];
        }

        public int getOutputGenerated() {
            return this.fields[1];
        }
    }
}

