/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts.AdtsAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts.AdtsStreamReader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;

public class AdtsContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(AdtsContainerProbe.class);

    @Override
    public String getName() {
        return "adts";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        boolean invalidMimeType = hints.mimeType != null && !"audio/aac".equalsIgnoreCase(hints.mimeType);
        boolean invalidFileExtension = hints.fileExtension != null && !"aac".equalsIgnoreCase(hints.fileExtension);
        return hints.present() && !invalidMimeType && !invalidFileExtension;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        AdtsStreamReader reader = new AdtsStreamReader(inputStream);
        if (reader.findPacketHeader(1000) == null) {
            return null;
        }
        log.debug("Track {} is an ADTS stream.", (Object)reference.identifier);
        return MediaContainerDetectionResult.supportedFormat(this, null, AudioTrackInfoBuilder.create(reference, inputStream).build());
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new AdtsAudioTrack(trackInfo, inputStream);
    }
}

