/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts;

import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts.AdtsPacketHeader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts.AdtsStreamReader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.ResettableBoundedInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class AdtsStreamProvider {
    private final AudioProcessingContext context;
    private final AdtsStreamReader streamReader;
    private final AacDecoder decoder;
    private final ResettableBoundedInputStream packetBoundedStream;
    private final DirectBufferStreamBroker directBufferBroker;
    private ShortBuffer outputBuffer;
    private AdtsPacketHeader previousHeader;
    private AudioPipeline downstream;
    private Long requestedTimecode;
    private Long providedTimecode;

    public AdtsStreamProvider(InputStream inputStream, AudioProcessingContext context) {
        this.context = context;
        this.streamReader = new AdtsStreamReader(inputStream);
        this.decoder = new AacDecoder();
        this.packetBoundedStream = new ResettableBoundedInputStream(inputStream);
        this.directBufferBroker = new DirectBufferStreamBroker(2048);
    }

    public void setInitialSeek(long requestedTimecode, long providedTimecode) {
        this.requestedTimecode = requestedTimecode;
        this.providedTimecode = providedTimecode;
    }

    public void provideFrames() throws InterruptedException {
        try {
            while (true) {
                AdtsPacketHeader header;
                if ((header = this.streamReader.findPacketHeader()) == null) {
                    return;
                }
                this.configureProcessing(header);
                this.packetBoundedStream.resetLimit(header.payloadLength);
                this.directBufferBroker.consumeNext(this.packetBoundedStream, Integer.MAX_VALUE, Integer.MAX_VALUE);
                ByteBuffer buffer = this.directBufferBroker.getBuffer();
                if (buffer.limit() < header.payloadLength) {
                    return;
                }
                this.decodeAndSend(buffer);
                this.streamReader.nextPacket();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void decodeAndSend(ByteBuffer inputBuffer) throws InterruptedException {
        this.decoder.fill(inputBuffer);
        if (this.downstream == null) {
            AacDecoder.StreamInfo streamInfo = this.decoder.resolveStreamInfo();
            if (streamInfo == null) {
                return;
            }
            this.downstream = AudioPipelineFactory.create(this.context, new PcmFormat(streamInfo.channels, streamInfo.sampleRate));
            this.outputBuffer = ByteBuffer.allocateDirect(2 * streamInfo.frameSize * streamInfo.channels).order(ByteOrder.nativeOrder()).asShortBuffer();
            if (this.requestedTimecode != null) {
                this.downstream.seekPerformed(this.requestedTimecode, this.providedTimecode);
                this.requestedTimecode = null;
            }
        }
        this.outputBuffer.clear();
        while (this.decoder.decode(this.outputBuffer, false)) {
            this.downstream.process(this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    private void configureProcessing(AdtsPacketHeader header) {
        if (!header.canUseSameDecoder(this.previousHeader)) {
            this.decoder.configure(header.profile, header.sampleRate, header.channels);
            if (this.downstream != null) {
                this.downstream.close();
            }
            this.downstream = null;
            this.outputBuffer = null;
        }
        this.previousHeader = header;
    }

    public void close() {
        try {
            if (this.downstream != null) {
                this.downstream.close();
            }
        }
        finally {
            this.decoder.close();
        }
    }
}

