/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.adts.AdtsPacketHeader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.BitBufferReader;

public class AdtsStreamReader {
    private static final AdtsPacketHeader EOF_PACKET = new AdtsPacketHeader(false, 0, 0, 0, 0);
    private static final int HEADER_BASE_SIZE = 7;
    private static final int INVALID_VALUE = -1;
    private static final int[] sampleRateMapping = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};
    private final InputStream inputStream;
    private final byte[] scanBuffer;
    private final ByteBuffer scanByteBuffer;
    private final BitBufferReader scanBufferReader;
    private AdtsPacketHeader currentPacket;

    public AdtsStreamReader(InputStream inputStream) {
        this.inputStream = inputStream;
        this.scanBuffer = new byte[32];
        this.scanByteBuffer = ByteBuffer.wrap(this.scanBuffer);
        this.scanBufferReader = new BitBufferReader(this.scanByteBuffer);
    }

    public AdtsPacketHeader findPacketHeader() throws IOException {
        return this.findPacketHeader(Integer.MAX_VALUE);
    }

    public AdtsPacketHeader findPacketHeader(int maximumDistance) throws IOException {
        if (this.currentPacket == null) {
            this.currentPacket = this.scanForPacketHeader(maximumDistance);
        }
        return this.currentPacket == EOF_PACKET ? null : this.currentPacket;
    }

    public void nextPacket() {
        this.currentPacket = null;
    }

    private AdtsPacketHeader scanForPacketHeader(int maximumDistance) throws IOException {
        int bufferPosition = 0;
        for (int i = 0; i < maximumDistance; ++i) {
            AdtsPacketHeader header;
            int nextByte = this.inputStream.read();
            if (nextByte == -1) {
                return EOF_PACKET;
            }
            this.scanBuffer[bufferPosition++] = (byte)nextByte;
            if (bufferPosition >= 7 && (header = this.readHeaderFromBufferTail(bufferPosition)) != null) {
                return header;
            }
            if (bufferPosition != this.scanBuffer.length) continue;
            AdtsStreamReader.copyEndToBeginning(this.scanBuffer, 7);
            bufferPosition = 7;
        }
        return null;
    }

    private AdtsPacketHeader readHeaderFromBufferTail(int position) throws IOException {
        this.scanByteBuffer.position(position - 7);
        AdtsPacketHeader header = AdtsStreamReader.readHeader(this.scanBufferReader);
        this.scanBufferReader.readRemainingBits();
        if (header == null) {
            return null;
        }
        if (!header.isProtectionAbsent) {
            int crcFirst = this.inputStream.read();
            int crcSecond = this.inputStream.read();
            if (crcFirst == -1 || crcSecond == -1) {
                return EOF_PACKET;
            }
        }
        return header;
    }

    private static void copyEndToBeginning(byte[] buffer, int chunk) {
        for (int i = 0; i < chunk; ++i) {
            buffer[i] = buffer[buffer.length - chunk + i];
        }
    }

    private static AdtsPacketHeader readHeader(BitBufferReader reader) {
        if ((reader.asLong(15) & 0x7FFBL) != 32760L) {
            return null;
        }
        boolean isProtectionAbsent = reader.asLong(1) == 1L;
        int profile = reader.asInteger(2);
        int sampleRate = sampleRateMapping[reader.asInteger(4)];
        reader.asLong(1);
        int channels = reader.asInteger(3);
        if (sampleRate == -1 || channels == 0) {
            return null;
        }
        reader.asLong(4);
        int frameLength = reader.asInteger(13);
        int payloadLength = frameLength - 7 - (isProtectionAbsent ? 0 : 2);
        reader.asLong(11);
        if (reader.asLong(2) != 0L) {
            return null;
        }
        return new AdtsPacketHeader(isProtectionAbsent, profile + 1, sampleRate, channels, payloadLength);
    }
}

