/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacFileLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;

public class FlacContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(FlacContainerProbe.class);
    private static final String TITLE_TAG = "TITLE";
    private static final String ARTIST_TAG = "ARTIST";

    @Override
    public String getName() {
        return "flac";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, FlacFileLoader.FLAC_CC)) {
            return null;
        }
        log.debug("Track {} is a FLAC file.", (Object)reference.identifier);
        FlacTrackInfo fileInfo = new FlacFileLoader(inputStream).parseHeaders();
        AudioTrackInfo trackInfo = AudioTrackInfoBuilder.create(reference, inputStream).setTitle(fileInfo.tags.get(TITLE_TAG)).setAuthor(fileInfo.tags.get(ARTIST_TAG)).setLength(fileInfo.duration).build();
        return MediaContainerDetectionResult.supportedFormat(this, null, trackInfo);
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new FlacAudioTrack(trackInfo, inputStream);
    }
}

