/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mp3;

import com.sedmelluq.discord.lavaplayer.natives.mp3.Mp3Decoder;
import java.io.IOException;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mp3.Mp3Seeker;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;

public class Mp3ConstantRateSeeker
implements Mp3Seeker {
    private static final int META_TAG_OFFSET = 36;
    private static final byte[][] META_TAGS = new byte[][]{{73, 110, 102, 111}, {76, 65, 77, 69}};
    private final double averageFrameSize;
    private final int sampleRate;
    private final long firstFramePosition;
    private final long contentLength;

    private Mp3ConstantRateSeeker(double averageFrameSize, int sampleRate, long firstFramePosition, long contentLength) {
        this.averageFrameSize = averageFrameSize;
        this.sampleRate = sampleRate;
        this.firstFramePosition = firstFramePosition;
        this.contentLength = contentLength;
    }

    public static Mp3ConstantRateSeeker createFromFrame(long firstFramePosition, long contentLength, byte[] frameBuffer) {
        int sampleRate = Mp3Decoder.getFrameSampleRate(frameBuffer, 0);
        double averageFrameSize = Mp3Decoder.getAverageFrameSize(frameBuffer, 0);
        return new Mp3ConstantRateSeeker(averageFrameSize, sampleRate, firstFramePosition, contentLength);
    }

    public static boolean isMetaFrame(byte[] frameBuffer) {
        for (byte[] metaTag : META_TAGS) {
            if (!DataFormatTools.arrayRangeEquals(frameBuffer, 36, metaTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getDuration() {
        return this.getMaximumFrameCount() * 1152L * 1000L / (long)this.sampleRate;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long seekAndGetFrameIndex(long timecode, SeekableInputStream inputStream) throws IOException {
        long maximumFrameCount = this.getMaximumFrameCount();
        long sampleIndex = timecode * (long)this.sampleRate / 1000L;
        long frameIndex = Math.min(sampleIndex / 1152L, maximumFrameCount);
        long seekPosition = (long)((double)frameIndex * this.averageFrameSize) - 8L;
        inputStream.seek(this.firstFramePosition + seekPosition);
        return frameIndex;
    }

    private long getMaximumFrameCount() {
        return (long)((double)(this.contentLength - this.firstFramePosition + 8L) / this.averageFrameSize);
    }
}

