/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg;

import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.common.AacPacketRouter;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import su.plo.voice.lavaplayer.libs.org.apache.commons.io.IOUtils;

public class MpegAacTrackConsumer
implements MpegTrackConsumer {
    private static final Logger log = LoggerFactory.getLogger(MpegAacTrackConsumer.class);
    private final MpegTrackInfo track;
    private final ByteBuffer inputBuffer;
    private final AacPacketRouter packetRouter;

    public MpegAacTrackConsumer(AudioProcessingContext context, MpegTrackInfo track) {
        this.track = track;
        this.inputBuffer = ByteBuffer.allocateDirect(4096);
        this.packetRouter = new AacPacketRouter(context, this::configureDecoder);
    }

    @Override
    public void initialise() {
        log.debug("Initialising AAC track with expected frequency {} and channel count {}.", (Object)this.track.sampleRate, (Object)this.track.channelCount);
    }

    @Override
    public MpegTrackInfo getTrack() {
        return this.track;
    }

    @Override
    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.packetRouter.seekPerformed(requestedTimecode, providedTimecode);
    }

    @Override
    public void flush() throws InterruptedException {
        this.packetRouter.flush();
    }

    @Override
    public void consume(ReadableByteChannel channel, int length) throws InterruptedException {
        int chunk;
        for (int remaining = length; remaining > 0; remaining -= chunk) {
            chunk = Math.min(remaining, this.inputBuffer.capacity());
            this.inputBuffer.clear();
            this.inputBuffer.limit(chunk);
            try {
                IOUtils.readFully(channel, this.inputBuffer);
            }
            catch (ClosedByInterruptException e) {
                log.trace("Interrupt received while reading channel", (Throwable)e);
                Thread.currentThread().interrupt();
                throw new InterruptedException();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.inputBuffer.flip();
            this.packetRouter.processInput(this.inputBuffer);
        }
    }

    @Override
    public void close() {
        this.packetRouter.close();
    }

    private void configureDecoder(AacDecoder decoder) {
        if (this.track.decoderConfig != null) {
            decoder.configure(this.track.decoderConfig);
        } else {
            decoder.configure(2, this.track.sampleRate, this.track.channelCount);
        }
    }
}

