/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegFileLoader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegNoopTrackConsumer;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;

public class MpegContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(MpegContainerProbe.class);
    private static final int[] ISO_TAG = new int[]{0, 0, 0, -1, 102, 116, 121, 112};

    @Override
    public String getName() {
        return "mp4";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, ISO_TAG)) {
            return null;
        }
        log.debug("Track {} is an MP4 file.", (Object)reference.identifier);
        MpegFileLoader file = new MpegFileLoader(inputStream);
        file.parseHeaders();
        MpegTrackInfo audioTrack = this.getSupportedAudioTrack(file);
        if (audioTrack == null) {
            return MediaContainerDetectionResult.unsupportedFormat(this, "No supported audio format in the MP4 file.");
        }
        MpegNoopTrackConsumer trackConsumer = new MpegNoopTrackConsumer(audioTrack);
        MpegFileTrackProvider fileReader = file.loadReader(trackConsumer);
        if (fileReader == null) {
            return MediaContainerDetectionResult.unsupportedFormat(this, "MP4 file uses an unsupported format.");
        }
        AudioTrackInfo trackInfo = AudioTrackInfoBuilder.create(reference, inputStream).setTitle(file.getTextMetadata("Title")).setAuthor(file.getTextMetadata("Artist")).setLength(fileReader.getDuration()).build();
        return MediaContainerDetectionResult.supportedFormat(this, null, trackInfo);
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new MpegAudioTrack(trackInfo, inputStream);
    }

    private MpegTrackInfo getSupportedAudioTrack(MpegFileLoader file) {
        for (MpegTrackInfo track : file.getTrackList()) {
            if (!"soun".equals(track.handler) || !"mp4a".equals(track.codecName)) continue;
            return track;
        }
        return null;
    }
}

