/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.fragmented;

public class MpegTrackFragmentHeader {
    public final int trackId;
    public final long baseTimecode;
    public final int dataOffset;
    public final int[] sampleDurations;
    public final int[] sampleSizes;

    public MpegTrackFragmentHeader(int trackId, long baseTimecode, int dataOffset, int[] sampleDurations, int[] sampleSizes) {
        this.trackId = trackId;
        this.baseTimecode = baseTimecode;
        this.dataOffset = dataOffset;
        this.sampleDurations = sampleDurations;
        this.sampleSizes = sampleSizes;
    }

    public static class Builder {
        private int trackId = -1;
        private long baseTimecode;
        private int dataOffset;
        private int defaultSampleSize;
        private int sampleCount;
        private int[] sampleDurations;
        private int[] sampleSizes;

        public int getTrackId() {
            return this.trackId;
        }

        public void setTrackId(int trackId) {
            this.trackId = trackId;
        }

        public void setBaseTimecode(long baseTimecode) {
            this.baseTimecode = baseTimecode;
        }

        public void setDataOffset(int dataOffset) {
            this.dataOffset = dataOffset;
        }

        public void setDefaultSampleSize(int defaultSampleSize) {
            this.defaultSampleSize = defaultSampleSize;
        }

        public void createSampleArrays(boolean hasDurations, boolean hasSizes, int sampleCount) {
            this.sampleCount = sampleCount;
            if (hasDurations) {
                this.sampleDurations = new int[sampleCount];
            }
            if (hasSizes) {
                this.sampleSizes = new int[sampleCount];
            }
        }

        public void setDuration(int i, int value) {
            this.sampleDurations[i] = value;
        }

        public void setSize(int i, int value) {
            this.sampleSizes[i] = value;
        }

        public MpegTrackFragmentHeader build() {
            int[] finalSampleSizes = this.sampleSizes;
            if (finalSampleSizes == null && this.defaultSampleSize != 0) {
                finalSampleSizes = new int[this.sampleCount];
                for (int i = 0; i < this.sampleCount; ++i) {
                    finalSampleSizes[i] = this.defaultSampleSize;
                }
            }
            return new MpegTrackFragmentHeader(this.trackId, this.baseTimecode, this.dataOffset, this.sampleDurations, finalSampleSizes);
        }
    }
}

