/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggSeekPoint;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;

public class OggPageScanner {
    private static final int OGG_PAGE_HEADER_INT = ByteBuffer.wrap(new byte[]{79, 103, 103, 83}).getInt(0);
    private final long absoluteOffset;
    private final byte[] data;
    private final int dataLength;
    private int flags;
    private long reversedPosition;
    private int pageSize;
    private long byteStreamPosition;
    private int pageSequence;

    public OggPageScanner(long absoluteOffset, byte[] data, int dataLength) {
        this.absoluteOffset = absoluteOffset;
        this.data = data;
        this.dataLength = dataLength;
    }

    public OggStreamSizeInfo scanForSizeInfo(long firstPageOffset, int sampleRate) {
        ByteBuffer buffer = ByteBuffer.wrap(this.data, 0, this.dataLength);
        int head = buffer.getInt(0);
        for (int i = 0; i < this.dataLength - 27; ++i) {
            if (head == OGG_PAGE_HEADER_INT) {
                buffer.position(i);
                if (this.attemptReadHeader(buffer)) {
                    do {
                        if ((this.flags & 4) == 0) continue;
                        return new OggStreamSizeInfo(this.byteStreamPosition - firstPageOffset + (long)this.pageSize, Long.reverseBytes(this.reversedPosition), firstPageOffset, this.byteStreamPosition, sampleRate);
                    } while (this.attemptReadHeader(buffer));
                }
            }
            head <<= 8;
            head |= this.data[i + 4] & 0xFF;
        }
        return null;
    }

    public List<OggSeekPoint> createSeekTable(int sampleRate) {
        ArrayList<OggSeekPoint> seekPoints = new ArrayList<OggSeekPoint>();
        ByteBuffer buffer = ByteBuffer.wrap(this.data, 0, this.dataLength);
        int head = buffer.getInt(0);
        for (int i = 0; i < this.dataLength - 27; ++i) {
            if (head == OGG_PAGE_HEADER_INT) {
                buffer.position(i);
                if (this.attemptReadHeader(buffer)) {
                    long position = this.byteStreamPosition;
                    long granulePosition = Long.reverseBytes(this.reversedPosition);
                    long timecode = granulePosition / (long)(sampleRate / 1000);
                    ++this.pageSequence;
                    seekPoints.add(new OggSeekPoint(position, granulePosition, timecode, this.pageSequence));
                }
            }
            head <<= 8;
            head |= this.data[i + 4] & 0xFF;
        }
        return seekPoints;
    }

    private boolean attemptReadHeader(ByteBuffer buffer) {
        int start = buffer.position();
        if (buffer.limit() < start + 27) {
            return false;
        }
        if (buffer.getInt(start) != OGG_PAGE_HEADER_INT) {
            return false;
        }
        if (buffer.get(start + 4) != 0) {
            return false;
        }
        int segmentCount = buffer.get(start + 26) & 0xFF;
        int minimumCapacity = start + segmentCount + 27;
        if (buffer.limit() < minimumCapacity) {
            return false;
        }
        int segmentBase = start + 27;
        for (int i = 0; i < segmentCount; ++i) {
            minimumCapacity += buffer.get(segmentBase + i) & 0xFF;
        }
        if (buffer.limit() < minimumCapacity) {
            return false;
        }
        this.flags = buffer.get(start + 5) & 0xFF;
        this.reversedPosition = buffer.getLong(start + 6);
        this.byteStreamPosition = this.absoluteOffset + (long)start;
        this.pageSize = minimumCapacity;
        buffer.position(minimumCapacity);
        return true;
    }
}

