/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.flac;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacMetadataReader;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacStreamInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfoBuilder;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggCodecHandler;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackBlueprint;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.flac.OggFlacTrackHandler;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.ByteBufferInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;

public class OggFlacCodecHandler
implements OggCodecHandler {
    private static final int FLAC_IDENTIFIER = ByteBuffer.wrap(new byte[]{127, 70, 76, 65}).getInt();
    private static final int NATIVE_FLAC_HEADER_OFFSET = 9;
    private static final int NATIVE_FLAC_HEADER = ByteBuffer.wrap(new byte[]{102, 76, 97, 67}).getInt();

    @Override
    public boolean isMatchingIdentifier(int identifier) {
        return identifier == FLAC_IDENTIFIER;
    }

    @Override
    public int getMaximumFirstPacketLength() {
        return 51;
    }

    @Override
    public OggTrackBlueprint loadBlueprint(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        FlacTrackInfo info = this.load(stream, broker);
        stream.setSeekPoints(stream.createSeekTable(info.stream.sampleRate));
        return new Blueprint(info);
    }

    @Override
    public OggMetadata loadMetadata(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        FlacTrackInfo info = this.load(stream, broker);
        return new OggMetadata(info.tags, this.detectLength(info, stream));
    }

    private FlacTrackInfo load(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        ByteBuffer buffer = broker.getBuffer();
        if (buffer.getInt(9) != NATIVE_FLAC_HEADER) {
            throw new IllegalStateException("Native flac header not found.");
        }
        buffer.position(13);
        return this.readHeaders(buffer, stream);
    }

    private Long detectLength(FlacTrackInfo info, OggPacketInputStream stream) throws IOException {
        OggStreamSizeInfo sizeInfo = info.stream.sampleCount > 0L ? new OggStreamSizeInfo(0L, info.stream.sampleCount, 0L, 0L, info.stream.sampleRate) : stream.seekForSizeInfo(info.stream.sampleRate);
        return sizeInfo != null ? Long.valueOf(sizeInfo.getDuration()) : null;
    }

    private FlacTrackInfo readHeaders(ByteBuffer firstPacketBuffer, OggPacketInputStream packetInputStream) throws IOException {
        FlacStreamInfo streamInfo = FlacMetadataReader.readStreamInfoBlock(new DataInputStream(new ByteBufferInputStream(firstPacketBuffer)));
        FlacTrackInfoBuilder trackInfoBuilder = new FlacTrackInfoBuilder(streamInfo);
        DataInputStream dataInputStream = new DataInputStream(packetInputStream);
        boolean hasMoreMetadata = trackInfoBuilder.getStreamInfo().hasMetadataBlocks;
        while (hasMoreMetadata) {
            if (!packetInputStream.startNewPacket()) {
                throw new IllegalStateException("Track ended when more metadata was expected.");
            }
            hasMoreMetadata = FlacMetadataReader.readMetadataBlock(dataInputStream, packetInputStream, trackInfoBuilder);
        }
        return trackInfoBuilder.build();
    }

    private static class Blueprint
    implements OggTrackBlueprint {
        private final FlacTrackInfo info;

        private Blueprint(FlacTrackInfo info) {
            this.info = info;
        }

        @Override
        public OggTrackHandler loadTrackHandler(OggPacketInputStream stream) {
            return new OggFlacTrackHandler(this.info, stream);
        }

        @Override
        public int getSampleRate() {
            return this.info.stream.sampleRate;
        }
    }
}

