/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.ogg.vorbis;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class VorbisCommentParser {
    public static Map<String, String> parse(ByteBuffer tagBuffer, boolean truncated) {
        HashMap<String, String> tags = new HashMap<String, String>();
        int vendorLength = Integer.reverseBytes(tagBuffer.getInt());
        if (vendorLength < 0) {
            throw new IllegalStateException("Ogg comments vendor length is negative.");
        }
        tagBuffer.position(tagBuffer.position() + vendorLength);
        int itemCount = Integer.reverseBytes(tagBuffer.getInt());
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            if (tagBuffer.remaining() < 4) {
                if (truncated) break;
                throw new IllegalArgumentException("Invalid tag buffer - tag size field out of bounds.");
            }
            int itemLength = Integer.reverseBytes(tagBuffer.getInt());
            if (itemLength < 0) {
                throw new IllegalStateException("Ogg comments tag item length is negative.");
            }
            if (tagBuffer.remaining() < itemLength) {
                if (truncated) break;
                throw new IllegalArgumentException("Invalid tag buffer - tag size field out of bounds.");
            }
            byte[] data = new byte[itemLength];
            tagBuffer.get(data);
            VorbisCommentParser.storeTagToMap(tags, data);
        }
        return tags;
    }

    private static void storeTagToMap(Map<String, String> tags, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 61) continue;
            tags.put(new String(data, 0, i, StandardCharsets.UTF_8).toUpperCase(Locale.ROOT), new String(data, i + 1, data.length - i - 1, StandardCharsets.UTF_8));
            break;
        }
    }
}

