/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.wav;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.container.wav.WavFileInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class WavTrackProvider {
    private static final int BLOCKS_IN_BUFFER = 4096;
    private final SeekableInputStream inputStream;
    private final DataInput dataInput;
    private final WavFileInfo info;
    private final int bytesPerSample;
    private final AudioPipeline downstream;
    private final short[] buffer;
    private final byte[] rawBuffer;
    private final ByteBuffer byteBuffer;

    public WavTrackProvider(AudioProcessingContext context, SeekableInputStream inputStream, WavFileInfo info) {
        this.inputStream = inputStream;
        this.dataInput = new DataInputStream(inputStream);
        this.info = info;
        this.bytesPerSample = info.bitsPerSample >> 3;
        this.downstream = AudioPipelineFactory.create(context, new PcmFormat(info.channelCount, info.sampleRate));
        this.buffer = info.getPadding() > 0 ? new short[info.channelCount * 4096] : null;
        this.byteBuffer = ByteBuffer.allocate(info.blockAlign * 4096).order(ByteOrder.LITTLE_ENDIAN);
        this.rawBuffer = this.byteBuffer.array();
    }

    public void seekToTimecode(long timecode) {
        try {
            long fileOffset = timecode * (long)this.info.sampleRate / 1000L * (long)this.info.blockAlign + this.info.startOffset;
            this.inputStream.seek(fileOffset);
            this.downstream.seekPerformed(timecode, timecode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void provideFrames() throws InterruptedException {
        try {
            int blockCount;
            while ((blockCount = this.getNextChunkBlocks()) > 0) {
                if (this.buffer != null) {
                    this.processChunkWithPadding(blockCount);
                    continue;
                }
                this.processChunk(blockCount);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.downstream.close();
    }

    private void processChunkWithPadding(int blockCount) throws IOException, InterruptedException {
        if (this.info.bitsPerSample != 16) {
            throw new IllegalStateException("Cannot process " + this.info.bitsPerSample + "-bit PCM with padding!");
        }
        this.readChunkToBuffer(blockCount);
        int padding = this.info.getPadding() / 2;
        int sampleCount = blockCount * this.info.channelCount;
        int indexInBlock = 0;
        for (int i = 0; i < sampleCount; ++i) {
            this.buffer[i] = this.byteBuffer.getShort();
            if (++indexInBlock != this.info.channelCount) continue;
            this.byteBuffer.position(this.byteBuffer.position() + padding);
            indexInBlock = 0;
        }
        this.downstream.process(this.buffer, 0, blockCount * this.info.channelCount);
    }

    private void processChunk(int blockCount) throws IOException, InterruptedException {
        int sampleCount = this.readChunkToBuffer(blockCount);
        if (this.info.bitsPerSample != 16) {
            for (int i = 0; i < sampleCount; ++i) {
                this.byteBuffer.putShort(i * 2, this.byteBuffer.getShort(i * this.bytesPerSample + this.bytesPerSample - 2));
            }
            this.byteBuffer.limit(sampleCount * 2);
        }
        this.downstream.process(this.byteBuffer.asShortBuffer());
    }

    private int readChunkToBuffer(int blockCount) throws IOException {
        int bytesToRead = blockCount * this.info.blockAlign;
        this.dataInput.readFully(this.rawBuffer, 0, bytesToRead);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(bytesToRead);
        return bytesToRead / this.bytesPerSample;
    }

    private int getNextChunkBlocks() {
        long endOffset = this.info.startOffset + (long)this.info.blockAlign * this.info.blockCount;
        return (int)Math.min((endOffset - this.inputStream.getPosition()) / (long)this.info.blockAlign, 4096L);
    }
}

