/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter;

import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.AudioFilterChain;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.CompositeAudioFilter;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.PcmFilterFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class UserProvidedAudioFilters
extends CompositeAudioFilter {
    private final AudioProcessingContext context;
    private final UniversalPcmAudioFilter nextFilter;
    private final boolean hotSwapEnabled;
    private AudioFilterChain chain;

    public UserProvidedAudioFilters(AudioProcessingContext context, UniversalPcmAudioFilter nextFilter) {
        this.context = context;
        this.nextFilter = nextFilter;
        this.hotSwapEnabled = context.filterHotSwapEnabled;
        this.chain = UserProvidedAudioFilters.buildFragment(context, nextFilter);
    }

    private static AudioFilterChain buildFragment(AudioProcessingContext context, UniversalPcmAudioFilter nextFilter) {
        PcmFilterFactory factory = context.playerOptions.filterFactory.get();
        if (factory == null) {
            return new AudioFilterChain(nextFilter, Collections.emptyList(), null);
        }
        FilterChainBuilder builder = new FilterChainBuilder();
        ArrayList<AudioFilter> filters = new ArrayList<AudioFilter>(factory.buildChain(null, context.outputFormat, nextFilter));
        if (filters.isEmpty()) {
            return new AudioFilterChain(nextFilter, Collections.emptyList(), null);
        }
        Collections.reverse(filters);
        for (AudioFilter filter : filters) {
            builder.addFirst(filter);
        }
        return builder.build(factory, context.outputFormat.channelCount);
    }

    @Override
    protected List<AudioFilter> getFilters() {
        return this.chain.filters;
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        this.checkRebuild();
        this.chain.input.process(input, offset, length);
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        this.checkRebuild();
        this.chain.input.process(input, offset, length);
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        this.checkRebuild();
        this.chain.input.process(buffer);
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        this.checkRebuild();
        this.chain.input.process(input, offset, length);
    }

    private void checkRebuild() throws InterruptedException {
        if (this.hotSwapEnabled && this.context.playerOptions.filterFactory.get() != this.chain.context) {
            this.flush();
            this.close();
            this.chain = UserProvidedAudioFilters.buildFragment(this.context, this.nextFilter);
        }
    }
}

