/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.format.transcoder;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;

public class PcmChunkEncoder
implements AudioChunkEncoder {
    private final ByteBuffer encoded;
    private final ShortBuffer encodedAsShort;

    public PcmChunkEncoder(AudioDataFormat format, boolean bigEndian) {
        this.encoded = ByteBuffer.allocate(format.maximumChunkSize());
        this.encoded.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.encodedAsShort = this.encoded.asShortBuffer();
    }

    @Override
    public byte[] encode(ShortBuffer buffer) {
        buffer.mark();
        this.encodedAsShort.clear();
        this.encodedAsShort.put(buffer);
        this.encoded.clear();
        this.encoded.limit(this.encodedAsShort.position() * 2);
        byte[] encodedBytes = new byte[this.encoded.remaining()];
        this.encoded.get(encodedBytes);
        buffer.reset();
        return encodedBytes;
    }

    @Override
    public void encode(ShortBuffer buffer, ByteBuffer out) {
        buffer.mark();
        this.encodedAsShort.clear();
        this.encodedAsShort.put(buffer);
        out.put(this.encoded.array(), 0, this.encodedAsShort.position() * 2);
        out.flip();
        buffer.reset();
    }

    @Override
    public void close() {
    }
}

