/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.beam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioSourceManager;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.beam.BeamSegmentUrlProvider;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.source.stream.MpegTsM3uStreamAudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import su.plo.voice.lavaplayer.libs.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;

public class BeamAudioTrack
extends MpegTsM3uStreamAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(BeamAudioTrack.class);
    private final BeamAudioSourceManager sourceManager;
    private final M3uStreamSegmentUrlProvider segmentUrlProvider;

    public BeamAudioTrack(AudioTrackInfo trackInfo, BeamAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
        this.segmentUrlProvider = new BeamSegmentUrlProvider(this.getChannelId());
    }

    @Override
    protected M3uStreamSegmentUrlProvider getSegmentUrlProvider() {
        return this.segmentUrlProvider;
    }

    @Override
    protected HttpInterface getHttpInterface() {
        return this.sourceManager.getHttpInterface();
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        log.debug("Starting to play Beam channel {}.", (Object)this.getChannelUrl());
        super.process(localExecutor);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new BeamAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    private String getChannelId() {
        return this.trackInfo.identifier.substring(0, this.trackInfo.identifier.indexOf(124));
    }

    private String getChannelUrl() {
        return this.trackInfo.identifier.substring(this.trackInfo.identifier.lastIndexOf(124) + 1);
    }
}

